/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.worldgen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTWorldGen;

public class DTTowerWonky
extends WorldGenerator {
    private static int minYLevel = 1;
    private static boolean netherTower = false;
    private static int netherChance = DTConfigHandler.configuration.get("7-World", "Nether Variant Chance", 9).getInt(9);
    private static int minHeight = DTConfigHandler.configuration.get("7-World", "Dungeon MinHeight", 3).getInt(3);
    private static int maxHeight = DTConfigHandler.configuration.get("7-World", "Dungeon MaxHeight", 10).getInt(10);
    private static int trap = 3;
    private static int floor = 1;
    private static boolean isVoid = false;
    private static Biome biome = Biomes.field_185440_P;
    private static final List<Block> useDecorative = Lists.newArrayList();
    private static final List<Block> trapVarient = Lists.newArrayList();

    public DTTowerWonky() {
        useDecorative.add(Blocks.field_150350_a);
        useDecorative.add(Blocks.field_150467_bQ);
        useDecorative.add(Blocks.field_150421_aI);
        useDecorative.add((Block)Blocks.field_150383_bp);
        useDecorative.add(Blocks.field_150462_ai);
        useDecorative.add(Blocks.field_150460_al);
        useDecorative.add(DTBlocks.BARREL);
        trapVarient.add(DTBlocks.TRAP_BOOM);
        trapVarient.add(DTBlocks.TRAP_FIRE);
        trapVarient.add(DTBlocks.TRAP_CLAMP);
        trapVarient.add(DTBlocks.TRAP_FOUL);
        trapVarient.add(DTBlocks.TRAP_AILMENT);
        trapVarient.add(DTBlocks.TRAP_PORT);
        trapVarient.add(DTBlocks.TRAP_AMBUSH);
        trapVarient.add(DTBlocks.TRAP_SPECTRAL);
    }

    public void settle(World world, Random rand, BlockPos start) {
        isVoid = world.field_73011_w.getBiomeForCoords(start) == Biomes.field_185440_P;
        BlockPos pos = DTWorldGen.settle(world, start, minYLevel, isVoid);
        DTWorldGen.printLocation("Complete", "Tower", pos);
        this.func_180709_b(world, rand, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return false;
    }

    public static boolean generateRoom(World world, Random rand, BlockPos pos) {
        int vert;
        int hor;
        ++floor;
        int size = 12;
        int csadjust = 7;
        int r = rand.nextInt(3);
        if (r == 2) {
            size = 15;
            csadjust = 10;
        }
        if (r == 0) {
            size = 9;
            csadjust = 4;
        }
        BlockPos cs = new BlockPos(pos.func_177958_n() - csadjust, pos.func_177956_o(), pos.func_177952_p() - csadjust);
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                for (int y = 0; y < 6; ++y) {
                    if (world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150358_i && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150356_k && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (hor = 0; hor < size; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (DTTowerWonky.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!DTTowerWonky.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(size - 1))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(size - 1), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < size; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (DTTowerWonky.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!DTTowerWonky.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(size - 1))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(size - 1), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < size; ++hor) {
            for (vert = 0; vert < size; ++vert) {
                if (!DTTowerWonky.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(2).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (DTTowerWonky.windowHelper(world, cs.func_177981_b(3).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        world.func_180501_a(pos.func_177984_a().func_177978_c().func_177974_f(), DTTowerWonky.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177974_f(), DTTowerWonky.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177968_d().func_177974_f(), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d(), DTTowerWonky.useStair(world, pos).func_176203_a(1), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177976_e(), DTTowerWonky.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(4).func_177976_e(), DTTowerWonky.useStair(world, pos).func_176203_a(3), 2);
        world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), DTTowerWonky.useStair(world, pos).func_176203_a(3), 2);
        if (DTTowerWonky.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177974_f())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177974_f());
        }
        if (DTTowerWonky.windowHelper(world, pos.func_177981_b(5).func_177968_d())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d());
        }
        if (DTTowerWonky.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177976_e());
        }
        if (DTTowerWonky.windowHelper(world, pos.func_177981_b(5).func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177976_e());
        }
        return true;
    }

    private static boolean terrainHelper(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        return block.func_177230_c() != DTBlocks.DUNGEON_GLASS && (block.func_177230_c() == Blocks.field_150350_a || !block.func_185915_l() || !block.func_185914_p());
    }

    private static boolean windowHelper(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150417_aV || block == Blocks.field_150322_A || block == Blocks.field_180395_cM || block == Blocks.field_150385_bj || block == Blocks.field_150418_aU || block == Blocks.field_150333_U || block == Blocks.field_180389_cP;
    }

    private static Block useBlock(World world, BlockPos pos) {
        if (biome == Biomes.field_76778_j || netherTower) {
            return Blocks.field_150385_bj;
        }
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s) {
            return Blocks.field_150322_A;
        }
        if (biome == Biomes.field_150589_Z || biome == Biomes.field_150608_ab || biome == Biomes.field_150607_aa) {
            return Blocks.field_180395_cM;
        }
        int block = world.field_73012_v.nextInt(9);
        Block result = block == 0 ? Blocks.field_150418_aU : Blocks.field_150417_aV;
        return result;
    }

    private static Block useStair(World world, BlockPos pos) {
        if (biome == Biomes.field_76778_j || netherTower) {
            return Blocks.field_150387_bl;
        }
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s) {
            return Blocks.field_150372_bz;
        }
        if (biome == Biomes.field_150589_Z || biome == Biomes.field_150608_ab || biome == Biomes.field_150607_aa) {
            return Blocks.field_180396_cN;
        }
        return Blocks.field_150390_bg;
    }

    private IBlockState useLog(World world, BlockPos pos) {
        if (biome == Biomes.field_76778_j || netherTower) {
            return DTBlocks.OBSIDIAN_BRICK.func_176223_P();
        }
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s || biome == Biomes.field_150588_X || biome == Biomes.field_150587_Y || biome == Biomes.field_150589_Z || biome == Biomes.field_150608_ab || biome == Biomes.field_150607_aa) {
            return Blocks.field_150363_s.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(1);
    }

    private IBlockState useSlab(World world, BlockPos pos) {
        if (biome == Biomes.field_76778_j || netherTower) {
            return Blocks.field_150333_U.func_176203_a(6);
        }
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s) {
            return Blocks.field_150333_U.func_176203_a(1);
        }
        if (biome == Biomes.field_150589_Z || biome == Biomes.field_150608_ab || biome == Biomes.field_150607_aa) {
            return Blocks.field_180389_cP.func_176203_a(0);
        }
        return Blocks.field_150333_U.func_176203_a(0);
    }

    private EnumFacing getDirection(String dir) {
        switch (dir) {
            case "north": {
                return EnumFacing.SOUTH;
            }
            case "south": {
                return EnumFacing.NORTH;
            }
            case "east": {
                return EnumFacing.WEST;
            }
            case "west": {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.NORTH;
    }
}

