/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.effects.enchantments.DTTrinketEnchantments;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.client.DTKeyRegister;
import pegbeard.dungeontactics.items.DTItemGeneric;
import pegbeard.dungeontactics.proxy.network.DTMessageTrinkets;
import pegbeard.dungeontactics.proxy.network.NetworkHandler;

public class DTTrinkets
extends DTItemGeneric {
    public DTTrinkets(String name, String string) {
        super(name);
        this.func_185043_a(new ResourceLocation(string), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return stack.func_77960_j();
            }
        });
    }

    public DTTrinkets(String name) {
        super(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.getDamage(stack) == 1) {
            tooltip.add("Active");
        }
        if (this.getDamage(stack) == 0) {
            tooltip.add("Inactive");
        }
    }

    public int func_77619_b() {
        if (this == DTItems.IRONRING) {
            return 1;
        }
        if (this == DTItems.GOLDENRING) {
            return 2;
        }
        if (this == DTItems.DIAMONDRING) {
            return 3;
        }
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isTrinketSlot(int slot) {
        return slot == 9 || slot == 10 || slot == 11 || slot == 12;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (stack.func_77952_i() == 1 && !this.isTrinketSlot(slot)) {
                stack.func_77964_b(0);
            }
            if (world.field_72995_K) {
                KeyBinding[] keyBindings = DTKeyRegister.keyBindings;
                if (slot == 9 && keyBindings[2].func_151468_f()) {
                    this.keyPressed(world, player, stack, slot);
                } else if (slot == 10 && keyBindings[3].func_151468_f()) {
                    this.keyPressed(world, player, stack, slot);
                } else if (slot == 11 && keyBindings[4].func_151468_f()) {
                    this.keyPressed(world, player, stack, slot);
                } else if (slot == 12 && keyBindings[5].func_151468_f()) {
                    this.keyPressed(world, player, stack, slot);
                }
            }
            if (!world.field_72995_K && stack.func_77952_i() == 1 && this.isTrinketSlot(slot)) {
                NBTTagList nbttaglist = stack.func_77986_q();
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
                    if (!(enchantment instanceof DTTrinketEnchantments)) continue;
                    int amp = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) - 1;
                    if (player.func_70644_a(this.getEffect(enchantment)) && player.func_70660_b(this.getEffect(enchantment)).func_76459_b() > 1) continue;
                    player.func_70690_d(new PotionEffect(this.getEffect(enchantment), 10, amp, false, false));
                    player.func_71020_j(((DTTrinketEnchantments)enchantment).getCost() * (float)amp);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(World world, EntityPlayer player, ItemStack stack, int slot) {
        if (stack.func_77973_b() instanceof DTTrinkets) {
            DTTrinkets.activateTrinket(world, player, stack);
        }
        NetworkHandler.INSTANCE.sendToServer((IMessage)new DTMessageTrinkets(slot));
    }

    public static void activateTrinket(World world, EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            stack.func_77964_b(0);
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.2f);
        } else if (stack.func_77952_i() == 0 && (stack.func_77948_v() || stack.func_77973_b() == DTItems.ICARUSRING)) {
            stack.func_77964_b(1);
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public Potion getEffect(Enchantment ench) {
        if (ench == DTEffects.SPEEDBOOST) {
            return MobEffects.field_76424_c;
        }
        if (ench == DTEffects.JUMPBOOST) {
            return MobEffects.field_76430_j;
        }
        if (ench == DTEffects.MININGHASTE) {
            return MobEffects.field_76422_e;
        }
        if (ench == DTEffects.WATERBREATHING) {
            return MobEffects.field_76427_o;
        }
        if (ench == DTEffects.FIRERESISTANCE) {
            return MobEffects.field_76426_n;
        }
        if (ench == DTEffects.NIGHTVISION) {
            return MobEffects.field_76439_r;
        }
        if (ench == DTEffects.RESISTANCE) {
            return MobEffects.field_76429_m;
        }
        if (ench == DTEffects.STRENGTH) {
            return MobEffects.field_76420_g;
        }
        if (ench == DTEffects.INVISIBILITY) {
            return MobEffects.field_76441_p;
        }
        return null;
    }
}

