/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.items.DTKnife;

public class DTBushGeneric
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.37, 0.0, 0.37, 0.63, 0.25, 0.63), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75), new AxisAlignedBB(0.06, 0.0, 0.06, 0.94, 0.88, 0.94), new AxisAlignedBB(0.06, 0.0, 0.06, 0.94, 0.88, 0.94)};

    public DTBushGeneric(String name) {
        super(Material.field_151585_k);
        this.setRegistryName("dungeontactics", name);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149647_a(DTCreativeTab.DT_BLOCKS_TAB);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.4f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        DTBushGeneric.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CROPS_AABB[0]);
        DTBushGeneric.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected Item getSeed() {
        return Item.func_150898_a((Block)this);
    }

    protected Item getCrop() {
        return Item.func_150898_a((Block)this);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == Blocks.field_150351_n || state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c() == Blocks.field_150341_Y || state.func_177230_c() == Blocks.field_150424_aL;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        if (!world.field_72995_K && (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge()) {
            if (!player.field_71075_bZ.field_75098_d) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge() - 1)), 2);
            }
            int ammount = 1 + world.field_73012_v.nextInt(3);
            for (int i = 0; i < ammount; ++i) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.54, (double)pos.func_177956_o() + 0.54, (double)pos.func_177952_p() + 0.54, new ItemStack(this.getCrop())));
            }
        }
        if (!stack.func_190926_b() && (stack.func_77973_b() instanceof ItemShears || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof DTKnife)) {
            this.func_149711_c(0.1f);
        } else {
            this.func_149711_c(0.6f);
        }
        super.func_180649_a(world, pos, player);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15 && this.func_176473_a(world, pos, state, world.field_72995_K) && this.func_180670_a(world, world.field_73012_v, pos, state)) {
            ItemDye.func_180617_a((World)world, (BlockPos)pos, (int)0);
        }
        if (!world.field_72995_K) {
            if ((Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge() - 1)), 2);
                }
                int ammount = 1 + world.field_73012_v.nextInt(3);
                for (int i = 0; i < ammount; ++i) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.54, (double)pos.func_177956_o() + 0.54, (double)pos.func_177952_p() + 0.54, new ItemStack(this.getCrop())));
                }
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15 && this.func_176473_a(world, pos, state, world.field_72995_K) && this.func_180670_a(world, world.field_73012_v, pos, state)) {
                this.func_176474_b(world, world.field_73012_v, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
            }
        }
        return true;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof EntityPlayer) {
            IBlockState state = world.func_180495_p(pos);
            if (!world.field_72995_K && world.field_73012_v.nextFloat() < fallDistance - 0.5f) {
                if (!world.func_82736_K().func_82766_b("mobGriefing")) {
                    return;
                }
                if (this.getAge(state) == 0) {
                    this.func_180653_a(world, pos, state, 0.5f, 0);
                    world.func_175698_g(pos);
                } else {
                    world.func_180501_a(pos, this.withAge(this.getAge(state) - 1), 2);
                }
            }
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int i;
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175671_l(pos.func_177984_a()) >= 4 && (i = this.getAge(state)) < this.getMaxAge()) {
            int rate = 25;
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b())) {
                rate = 15;
            }
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt(rate) == 0 ? 1 : 0) != 0) && (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) < this.getMaxAge()) {
                world.func_180501_a(pos, this.withAge(i + 1), 2);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getSeed();
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
        int age = this.getAge(state);
        if (age >= this.getMaxAge() - 1) {
            drops.add((Object)new ItemStack(this.getSeed(), 1, 0));
            if (age >= this.getMaxAge()) {
                Random rand = new Random();
                int amount = 1 + rand.nextInt(3);
                drops.add((Object)new ItemStack(this.getCrop(), amount, 0));
            }
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, world.field_72995_K);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(world);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        world.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World world) {
        return MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }
}

