/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.MapManager;
import org.dynmap.hdmap.DefaultHDLighting;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.LightLevels;

public class ShadowHDLighting
extends DefaultHDLighting {
    protected final int[] defLightingTable;
    protected final int[] lightscale;
    protected final boolean night_and_day;
    protected final boolean smooth;
    protected final boolean useWorldBrightnessTable;

    public ShadowHDLighting(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        double shadowweight = configuration.getDouble("shadowstrength", 0.0);
        this.useWorldBrightnessTable = configuration.getBoolean("use-brightness-table", MapManager.mapman.useBrightnessTable());
        this.defLightingTable = new int[16];
        this.defLightingTable[15] = 256;
        for (int i = 14; i >= 0; --i) {
            double v = (double)this.defLightingTable[i + 1] * (1.0 - 0.2 * shadowweight);
            this.defLightingTable[i] = (int)v;
            if (this.defLightingTable[i] > 256) {
                this.defLightingTable[i] = 256;
            }
            if (this.defLightingTable[i] >= 0) continue;
            this.defLightingTable[i] = 0;
        }
        int v = configuration.getInteger("ambientlight", -1);
        if (v < 0) {
            v = 15;
        }
        if (v > 15) {
            v = 15;
        }
        this.night_and_day = configuration.getBoolean("night-and-day", false);
        this.lightscale = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.lightscale[i] = i < 15 - v ? 0 : i - (15 - v);
        }
        this.smooth = configuration.getBoolean("smooth-lighting", MapManager.mapman.getSmoothLighting());
    }

    private void applySmoothLighting(HDPerspectiveState ps, HDShaderState ss, Color incolor, Color[] outcolor, int[] shadowscale) {
        Color c;
        int w2;
        BlockStep s2;
        int w1;
        BlockStep s1;
        int[] xyz = ps.getSubblockCoord();
        int scale = (int)ps.getScale();
        int mid = scale / 2;
        switch (ps.getLastBlockStep()) {
            case X_MINUS: 
            case X_PLUS: {
                if (xyz[1] < mid) {
                    s1 = BlockStep.Y_MINUS;
                    w1 = mid - xyz[1];
                } else {
                    s1 = BlockStep.Y_PLUS;
                    w1 = xyz[1] - mid;
                }
                if (xyz[2] < mid) {
                    s2 = BlockStep.Z_MINUS;
                    w2 = mid - xyz[2];
                    break;
                }
                s2 = BlockStep.Z_PLUS;
                w2 = xyz[2] - mid;
                break;
            }
            case Z_MINUS: 
            case Z_PLUS: {
                if (xyz[0] < mid) {
                    s1 = BlockStep.X_MINUS;
                    w1 = mid - xyz[0];
                } else {
                    s1 = BlockStep.X_PLUS;
                    w1 = xyz[0] - mid;
                }
                if (xyz[1] < mid) {
                    s2 = BlockStep.Y_MINUS;
                    w2 = mid - xyz[1];
                    break;
                }
                s2 = BlockStep.Y_PLUS;
                w2 = xyz[1] - mid;
                break;
            }
            default: {
                if (xyz[0] < mid) {
                    s1 = BlockStep.X_MINUS;
                    w1 = mid - xyz[0];
                } else {
                    s1 = BlockStep.X_PLUS;
                    w1 = xyz[0] - mid;
                }
                if (xyz[2] < mid) {
                    s2 = BlockStep.Z_MINUS;
                    w2 = mid - xyz[2];
                    break;
                }
                s2 = BlockStep.Z_PLUS;
                w2 = xyz[2] - mid;
            }
        }
        LightLevels skyemit0 = ps.getCachedLightLevels(0);
        ps.getLightLevels(skyemit0);
        LightLevels skyemit1 = ps.getCachedLightLevels(1);
        ps.getLightLevelsAtStep(s1, skyemit1);
        LightLevels skyemit2 = ps.getCachedLightLevels(2);
        ps.getLightLevelsAtStep(s2, skyemit2);
        int ll0 = this.getLightLevel(skyemit0, true);
        int ll1 = this.getLightLevel(skyemit1, true);
        int weight = 0;
        if (ll1 < ll0) {
            weight -= w1;
        } else if (ll1 > ll0) {
            weight += w1;
        }
        int ll2 = this.getLightLevel(skyemit2, true);
        if (ll2 < ll0) {
            weight -= w2;
        } else if (ll2 > ll0) {
            weight += w2;
        }
        outcolor[0].setColor(incolor);
        int cscale = 256;
        if (weight == 0) {
            cscale = shadowscale[ll0];
        } else if (weight < 0) {
            weight = -weight;
            cscale = ll0 > 0 ? (shadowscale[ll0] * (scale - weight) + shadowscale[ll0 - 1] * weight) / scale : shadowscale[ll0];
        } else {
            cscale = ll0 < 15 ? (shadowscale[ll0] * (scale - weight) + shadowscale[ll0 + 1] * weight) / scale : shadowscale[ll0];
        }
        if (cscale < 256) {
            c = outcolor[0];
            c.setRGBA(c.getRed() * cscale >> 8, c.getGreen() * cscale >> 8, c.getBlue() * cscale >> 8, c.getAlpha());
        }
        if (outcolor.length > 1) {
            ll0 = this.getLightLevel(skyemit0, false);
            ll1 = this.getLightLevel(skyemit1, false);
            weight = 0;
            if (ll1 < ll0) {
                weight -= w1;
            } else if (ll1 > ll0) {
                weight += w1;
            }
            ll2 = this.getLightLevel(skyemit2, false);
            if (ll2 < ll0) {
                weight -= w2;
            } else if (ll2 > ll0) {
                weight += w2;
            }
            outcolor[1].setColor(incolor);
            cscale = 256;
            if (weight == 0) {
                cscale = shadowscale[ll0];
            } else if (weight < 0) {
                weight = -weight;
                cscale = ll0 > 0 ? (shadowscale[ll0] * (scale - weight) + shadowscale[ll0 - 1] * weight) / scale : shadowscale[ll0];
            } else {
                cscale = ll0 < 15 ? (shadowscale[ll0] * (scale - weight) + shadowscale[ll0 + 1] * weight) / scale : shadowscale[ll0];
            }
            if (cscale < 256) {
                c = outcolor[1];
                c.setRGBA(c.getRed() * cscale >> 8, c.getGreen() * cscale >> 8, c.getBlue() * cscale >> 8, c.getAlpha());
            }
        }
    }

    private final int getLightLevel(LightLevels ll, boolean useambient) {
        int lightlevel = useambient ? this.lightscale[ll.sky] : ll.sky;
        if (lightlevel < 15) {
            lightlevel = Math.max(ll.emitted, lightlevel);
        }
        return lightlevel;
    }

    @Override
    public void applyLighting(HDPerspectiveState ps, HDShaderState ss, Color incolor, Color[] outcolor) {
        int[] shadowscale = null;
        if (this.smooth) {
            shadowscale = ss.getLightingTable();
            if (shadowscale == null) {
                shadowscale = this.defLightingTable;
            }
            this.applySmoothLighting(ps, ss, incolor, outcolor, shadowscale);
            this.checkGrayscale(outcolor);
            return;
        }
        LightLevels ll = null;
        int lightlevel = 15;
        int lightlevel_day = 15;
        if (this.defLightingTable != null) {
            shadowscale = ss.getLightingTable();
            if (shadowscale == null) {
                shadowscale = this.defLightingTable;
            }
            ll = ps.getCachedLightLevels(0);
            ps.getLightLevels(ll);
            lightlevel = lightlevel_day = ll.sky;
        }
        if ((lightlevel = this.lightscale[lightlevel]) < 15 || lightlevel_day < 15) {
            int emitted = ll.emitted;
            lightlevel = Math.max(emitted, lightlevel);
            lightlevel_day = Math.max(emitted, lightlevel_day);
        }
        outcolor[0].setColor(incolor);
        if (lightlevel < 15) {
            this.shadowColor(outcolor[0], lightlevel, shadowscale);
        }
        if (outcolor.length > 1) {
            if (lightlevel_day == lightlevel) {
                outcolor[1].setColor(outcolor[0]);
            } else {
                outcolor[1].setColor(incolor);
                if (lightlevel_day < 15) {
                    this.shadowColor(outcolor[1], lightlevel_day, shadowscale);
                }
            }
        }
        this.checkGrayscale(outcolor);
    }

    private final void shadowColor(Color c, int lightlevel, int[] shadowscale) {
        int scale = shadowscale[lightlevel];
        if (scale < 256) {
            c.setRGBA(c.getRed() * scale >> 8, c.getGreen() * scale >> 8, c.getBlue() * scale >> 8, c.getAlpha());
        }
    }

    @Override
    public boolean isNightAndDayEnabled() {
        return this.night_and_day;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return true;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return true;
    }

    @Override
    public int[] getBrightnessTable(DynmapWorld world) {
        if (this.useWorldBrightnessTable) {
            return world.getBrightnessTable();
        }
        return null;
    }
}

