/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChopMod;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.event.ChopEvent;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.TreeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChopUtil {
    public static boolean isBlockChoppable(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() instanceof IChoppableBlock || ChopUtil.isBlockALog(blockState) && (!ChopUtil.isBlockALog(world, pos.func_177976_e()) || !ChopUtil.isBlockALog(world, pos.func_177978_c()) || !ChopUtil.isBlockALog(world, pos.func_177974_f()) || !ChopUtil.isBlockALog(world, pos.func_177968_d()));
    }

    public static boolean isBlockChoppable(World world, BlockPos pos) {
        return ChopUtil.isBlockChoppable(world, pos, world.func_180495_p(pos));
    }

    public static boolean isBlockALog(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IChoppableBlock || ConfigHandler.getLogBlocks().contains(block) || ChopUtil.isMushroomStem(blockState);
    }

    public static boolean isBlockALog(World world, BlockPos pos) {
        return ChopUtil.isBlockALog(world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(World world, BlockPos pos) {
        return ChopUtil.isBlockLeaves(world.func_180495_p(pos));
    }

    public static boolean isBlockLeaves(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (ConfigHandler.getLeavesBlocks().contains(block) || ChopUtil.isMushroomCap(blockState)) {
            return !ConfigHandler.COMMON.ignorePersistentLeaves.get() || !blockState.func_177227_a().contains(BlockLeaves.field_176237_a) || (Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a) != false;
        }
        return false;
    }

    private static boolean isMushroomCap(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockHugeMushroom) {
            BlockHugeMushroom.EnumType variant = (BlockHugeMushroom.EnumType)blockState.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
            return variant != BlockHugeMushroom.EnumType.STEM && variant != BlockHugeMushroom.EnumType.ALL_STEM;
        }
        return false;
    }

    private static boolean isMushroomStem(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockHugeMushroom) {
            BlockHugeMushroom.EnumType variant = (BlockHugeMushroom.EnumType)blockState.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
            return variant == BlockHugeMushroom.EnumType.STEM || variant == BlockHugeMushroom.EnumType.ALL_STEM;
        }
        return false;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static boolean canChangeBlock(BlockPos blockPos, EntityPlayer agent, ItemStack tool) {
        return tool.func_190926_b() || !tool.func_77973_b().onBlockStartBreak(tool, blockPos, agent);
    }

    public static List<BlockPos> getTreeLeaves(World world, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxNumLeavesBlocks = ConfigHandler.COMMON.maxNumLeavesBlocks;
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            IBlockState blockState = world.func_180495_p(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.func_177230_c() instanceof BlockLeaves) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(world, pos2, iterationCounter, leaves));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(World world, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy) {
        IBlockState blockState = world.func_180495_p(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (iterationCounter.get() >= ConfigHandler.COMMON.maxBreakLeavesDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int numBlocks) {
        return ConfigHandler.COMMON.chopCountingAlgorithm.get().calculate(numBlocks);
    }

    public static ChopResult getChopResult(World world, BlockPos blockPos, EntityPlayer agent, int numChops, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(world, blockPos, agent, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(world, blockPos, numChops);
    }

    private static ChopResult getChopResult(World world, BlockPos blockPos, EntityPlayer agent, int numChops, Predicate<BlockPos> logCondition) {
        Set<BlockPos> supportedBlocks = ChopUtil.getTreeBlocks(world, blockPos, logCondition, ChopUtil.getPlayerChopSettings(agent).getTreesMustHaveLeaves());
        return ChopUtil.chopTree(world, blockPos, supportedBlocks, numChops);
    }

    private static Set<BlockPos> getTreeBlocks(World world, BlockPos blockPos, Predicate<BlockPos> logCondition, boolean mustHaveLeaves) {
        AtomicBoolean hasLeaves = new AtomicBoolean(!mustHaveLeaves);
        Set<BlockPos> treeBlocks = ChopUtil.getTreeBlocks(world, blockPos, logCondition, hasLeaves);
        return hasLeaves.get() ? treeBlocks : Collections.emptySet();
    }

    private static Set<BlockPos> getTreeBlocks(World world, BlockPos blockPos, Predicate<BlockPos> logCondition, AtomicBoolean inHasLeaves) {
        if (!logCondition.test(blockPos)) {
            return Collections.emptySet();
        }
        AtomicBoolean overrideHasLeaves = new AtomicBoolean(inHasLeaves.get());
        ChopEvent.DetectTreeEvent detectEvent = new ChopEvent.DetectTreeEvent(world, null, blockPos, world.func_180495_p(blockPos), inHasLeaves, overrideHasLeaves);
        boolean valueToOverrideHasLeaves = inHasLeaves.get();
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)detectEvent);
        if (canceled) {
            return Collections.emptySet();
        }
        int maxNumTreeBlocks = ConfigHandler.COMMON.maxNumTreeBlocks;
        AtomicBoolean trueHasLeaves = new AtomicBoolean(false);
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> trueHasLeaves.compareAndSet(false, ChopUtil.isBlockLeaves(world, pos))).filter(logCondition), maxNumTreeBlocks);
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            TreeChopMod.LOGGER.warn(String.format("Max tree size reached: %d >= %d blocks (not including leaves)", supportedBlocks.size(), maxNumTreeBlocks));
        }
        inHasLeaves.set(overrideHasLeaves.get() ? valueToOverrideHasLeaves : trueHasLeaves.get());
        return supportedBlocks;
    }

    private static ChopResult chopTree(World world, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        if (supportedBlocks.isEmpty()) {
            return ChopResult.IGNORED;
        }
        IBlockState blockState = world.func_180495_p(target);
        int currentNumChops = ChopUtil.getNumChops(blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(supportedBlocks.size()))) {
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> Math.abs(checkPos.func_177956_o() - target.func_177956_o()) < 4 && ChopUtil.isBlockChoppable(world, checkPos)), 64);
            int totalNumChops = ChopUtil.getNumChops(world, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List choppedLogsSortedByY = nearbyChoppableBlocks.stream().filter(pos1 -> world.func_180495_p(pos1).func_177230_c() instanceof IChoppableBlock).sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
                for (BlockPos pos2 : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(world, pos2);
                    supportedBlocks.add(pos2);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                nearbyChoppableBlocks.remove(target);
                return ChopUtil.gatherChops(world, target, numChops, nearbyChoppableBlocks);
            }
        }
        supportedBlocks.remove(target);
        return new ChopResult(world, Collections.singletonList(target), supportedBlocks);
    }

    private static ChopResult gatherChops(World world, BlockPos target, int numChops, Set<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        LinkedList<TreeBlock> choppedBlocks = new LinkedList<TreeBlock>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, target, numChops, choppedBlocks);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.stream().filter(blockPos1 -> {
            IBlockState blockState1 = world.func_180495_p(blockPos1);
            Block block1 = blockState1.func_177230_c();
            if (block1 instanceof IChoppableBlock) {
                return ChopUtil.getNumChops(blockState1) < ChopUtil.getMaxNumChops(world, blockPos1, blockState1);
            }
            return blockPos1.func_177956_o() >= target.func_177956_o();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(world, nextTarget = (BlockPos)iterator.next(), numChopsLeft, choppedBlocks)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(choppedBlocks);
    }

    private static int gatherChopAndGetNumChopsRemaining(World world, BlockPos target, int numChops, List<TreeBlock> choppedBlocks) {
        IBlockState blockStateAfterChopping;
        IBlockState blockStateBeforeChopping = world.func_180495_p(target);
        if (blockStateBeforeChopping != (blockStateAfterChopping = ChopUtil.getBlockStateAfterChops(world, target, numChops, false))) {
            choppedBlocks.add(new TreeBlock(world, target, blockStateAfterChopping, true));
        }
        return numChops - (ChopUtil.getNumChops(blockStateAfterChopping) - ChopUtil.getNumChops(blockStateBeforeChopping));
    }

    public static IBlockState getBlockStateAfterChops(World world, BlockPos blockPos, int numChops, boolean destructive) {
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppableBlock) {
            return ChopUtil.getBlockStateAfterChops((IChoppableBlock)block, blockState, numChops, destructive);
        }
        if (ChopUtil.isBlockChoppable(world, blockPos, blockState)) {
            ChoppedLogShape shape = ChoppedLogBlock.getPlacementShape(world, blockPos);
            IChoppableBlock choppedBlock = ChopUtil.getChoppedBlock(blockState, shape);
            if (choppedBlock instanceof Block) {
                IBlockState defaultChoppedState = ((Block)choppedBlock).func_176223_P();
                return ChopUtil.getBlockStateAfterChops(choppedBlock, defaultChoppedState, numChops - ChopUtil.getNumChops(defaultChoppedState), destructive);
            }
            throw new IllegalArgumentException(String.format("Block \"%s\" is not choppable", block.getRegistryName()));
        }
        return blockState;
    }

    public static IBlockState getBlockStateAfterChops(IChoppableBlock choppableBlock, IBlockState blockState, int numChops, boolean destructive) {
        int maxNumChops;
        int currentNumChops = ChopUtil.getNumChops(blockState);
        int newNumChops = currentNumChops + numChops;
        if (newNumChops <= (maxNumChops = choppableBlock.getMaxNumChops())) {
            return choppableBlock.withChops(blockState, newNumChops);
        }
        return destructive ? Blocks.field_150350_a.func_176223_P() : choppableBlock.withChops(blockState, maxNumChops);
    }

    public static int getMaxNumChops(World world, BlockPos blockPos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof IChoppableBlock) {
            return ((IChoppableBlock)block).getMaxNumChops();
        }
        if (ChopUtil.isBlockChoppable(world, blockPos, world.func_180495_p(blockPos))) {
            IChoppableBlock choppedBlock = ChopUtil.getChoppedBlock(blockState, ChoppedLogShape.PILLAR);
            return choppedBlock != null ? choppedBlock.getMaxNumChops() : 0;
        }
        return 0;
    }

    public static IChoppableBlock getChoppedBlock(IBlockState blockState, ChoppedLogShape shape) {
        if (ChopUtil.isBlockALog(blockState)) {
            return blockState.func_177230_c() instanceof IChoppableBlock ? (IChoppableBlock)blockState.func_177230_c() : (IChoppableBlock)ModBlocks.CHOPPED_LOGS.get((Object)shape);
        }
        return null;
    }

    public static int getNumChops(World world, BlockPos pos) {
        return ChopUtil.getNumChops(world.func_180495_p(pos));
    }

    public static int getNumChops(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block instanceof IChoppableBlock ? ((IChoppableBlock)block).getNumChops(blockState) : 0;
    }

    public static int getNumChops(World world, Set<BlockPos> positions) {
        return positions.stream().map(arg_0 -> ((World)world).func_180495_p(arg_0)).map(blockState1 -> blockState1.func_177230_c() instanceof IChoppableBlock ? ((IChoppableBlock)blockState1.func_177230_c()).getNumChops((IBlockState)blockState1) : 0).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(World world, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(world, blockPos) ? new ChopResult(Collections.singletonList(new TreeBlock(world, blockPos, ChopUtil.getBlockStateAfterChops(world, blockPos, numChops, true), true)), false) : ChopResult.IGNORED;
    }

    public static int manhattanDistance(BlockPos a, BlockPos b) {
        float f = Math.abs(a.func_177958_n() - b.func_177958_n());
        float f1 = Math.abs(a.func_177956_o() - b.func_177956_o());
        float f2 = Math.abs(a.func_177952_p() - b.func_177952_p());
        return (int)(f + f1 + f2);
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return ChopUtil.manhattanDistance(a, b);
    }

    public static boolean canChopWithTool(ItemStack tool) {
        return ConfigHandler.canChopWithItem(tool.func_77973_b());
    }

    public static int getNumChopsByTool(ItemStack tool, IBlockState blockState) {
        Item toolItem = tool.func_77973_b();
        if (toolItem instanceof IChoppingItem) {
            return ((IChoppingItem)toolItem).getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(EntityPlayer player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToChop(player, chopSettings);
    }

    public static boolean playerWantsToChop(EntityPlayer player, ChopSettings chopSettings) {
        if (!player.func_184812_l_() || chopSettings.getChopInCreativeMode()) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(EntityPlayer player) {
        ChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        return ChopUtil.playerWantsToFell(player, chopSettings);
    }

    public static boolean playerWantsToFell(EntityPlayer player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static ChopSettings getPlayerChopSettings(EntityPlayer player) {
        Optional<ChopSettingsCapability> playerSettings = ChopSettingsCapability.forPlayer(player);
        return playerSettings.isPresent() ? (ChopSettings)playerSettings.get() : ConfigHandler.fakePlayerChopSettings;
    }

    public static void doItemDamage(ItemStack itemStack, World world, IBlockState blockState, BlockPos blockPos, EntityPlayer agent) {
        ItemStack mockItemStack = itemStack.func_77946_l();
        itemStack.func_179548_a(world, blockState, blockPos, agent);
        if (itemStack.func_190926_b() && !mockItemStack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)agent, (ItemStack)mockItemStack, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    public static void dropExperience(World world, BlockPos blockPos, int amount) {
        if (world instanceof WorldServer) {
            Blocks.field_150350_a.func_180637_b(world, blockPos, amount);
        }
    }

    public static boolean isPartOfATree(World world, BlockPos pos, boolean mustHaveLeaves) {
        AtomicBoolean hasLeaves = new AtomicBoolean(false);
        Set<BlockPos> treeBlocks = ChopUtil.getTreeBlocks(world, pos, (BlockPos blockPos) -> ChopUtil.isBlockALog(world, blockPos), hasLeaves);
        if (treeBlocks.isEmpty()) {
            return false;
        }
        if (mustHaveLeaves) {
            return hasLeaves.get();
        }
        return treeBlocks.size() >= (hasLeaves.get() ? 1 : 2);
    }
}

