/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;

public enum SneakBehavior implements IStringSerializable
{
    NONE("treechop.sneak_behavior.none", agent -> false, agent -> false),
    INVERT_CHOPPING("treechop.sneak_behavior.invert_chopping", Entity::func_70093_af, agent -> false),
    INVERT_FELLING("treechop.sneak_behavior.invert_felling", agent -> false, Entity::func_70093_af);

    public static final int maxNameLength;
    private final Predicate<Entity> chopBehavior;
    private final Predicate<Entity> fellBehavior;
    private final String langKey;

    private SneakBehavior(String langKey, Predicate<Entity> chopBehavior, Predicate<Entity> fellBehavior) {
        this.chopBehavior = chopBehavior;
        this.fellBehavior = fellBehavior;
        this.langKey = langKey;
    }

    public SneakBehavior cycle() {
        return SneakBehavior.values()[Math.floorMod(this.ordinal() + 1, SneakBehavior.values().length)];
    }

    public String toString() {
        return this.name();
    }

    public String func_176610_l() {
        return this.name();
    }

    public boolean shouldChangeChopBehavior(Entity agent) {
        return this.chopBehavior.test(agent);
    }

    public boolean shouldChangeFellBehavior(Entity agent) {
        return this.fellBehavior.test(agent);
    }

    public String getFancyText() {
        return I18n.func_135052_a((String)this.langKey, (Object[])new Object[0]);
    }

    static {
        maxNameLength = Arrays.stream(SneakBehavior.values()).map(Enum::name).map(String::length).max(Integer::compareTo).orElse(0);
    }
}

