/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ConfirmedSetting
extends Setting {
    protected final Event event;

    public ConfirmedSetting(Setting setting, Event event) {
        super(setting.getField(), setting.getValue());
        this.event = event;
    }

    public static void encode(ByteBuf buffer, ConfirmedSetting setting) {
        Setting.encode(buffer, setting);
        setting.event.encode(buffer);
    }

    public static ConfirmedSetting decode(ByteBuf buffer) {
        Setting setting = Setting.decode(buffer);
        Event event = Event.decode(buffer);
        return new ConfirmedSetting(setting, event);
    }

    public static enum Event {
        ACCEPT{

            @Override
            public void run(ConfirmedSetting setting) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    String fieldName = setting.getField().getFancyName();
                    String valueName = setting.getField().getValueName(setting.getValue());
                    if (ConfigHandler.CLIENT.showFeedbackMessages.get()) {
                        TreeChopMod.showText(String.format("%s %s", fieldName, valueName));
                    }
                }
            }
        }
        ,
        DENY{

            @Override
            public void run(ConfirmedSetting setting) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    String fieldName = setting.getField().getFancyName();
                    String valueName = setting.getField().getValueName(setting.getValue());
                    if (ConfigHandler.CLIENT.showFeedbackMessages.get()) {
                        TreeChopMod.showText(String.format("%s %s %s(%s)", fieldName, valueName, TextFormatting.RED, I18n.func_135052_a((String)"treechop.setting.missing_permissions", (Object[])new Object[0])));
                    }
                }
            }
        }
        ,
        SILENT;

        private static final Event[] values;

        public void run(ConfirmedSetting message) {
        }

        public static Event decode(ByteBuf buffer) {
            int ordinal = buffer.readByte() % values.length;
            return values[ordinal];
        }

        public void encode(ByteBuf buffer) {
            buffer.writeByte(this.ordinal());
        }

        static {
            values = Event.values();
        }
    }
}

