/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Handle;
import java.util.Arrays;

public class EnumHandle<T extends Enum<T>>
extends Handle {
    private T value;

    public EnumHandle(String category, String key, T defaultValue, String comment, Class<T> enumClass) {
        super(category, key);
        CharSequence[] possibleValues = EnumHandle.getEnumValuesAsStrings(enumClass);
        this.value = Enum.valueOf(enumClass, ConfigHandler.getConfig().getString(key, this.getCategory(), ((Enum)defaultValue).name(), String.format("%s\nOptions: %s", comment, String.join((CharSequence)", ", possibleValues)), (String[])possibleValues, (String[])possibleValues));
    }

    private static <T extends Enum<T>> String[] getEnumValuesAsStrings(Class<T> enumClass) {
        return (String[])Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new);
    }

    public T get() {
        return this.value;
    }

    void set(T value) {
        String stringValue = ((Enum)value).name();
        ConfigHandler.getConfig().get(this.getCategory(), this.getKey(), stringValue).set(stringValue);
        this.value = value;
        ConfigHandler.saveConfig();
    }
}

