/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import com.google.common.collect.Lists;
import ht.treechop.TreeChopMod;
import ht.treechop.client.Client;
import ht.treechop.common.config.BooleanHandle;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.EnumHandle;
import ht.treechop.common.config.ListType;
import ht.treechop.common.config.Rounder;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.server.Server;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    private static final String LIST_SEPARATOR = ",";
    private static List<String> choppingToolBlacklistNames;
    private static Set<Block> logBlocks;
    private static Set<Block> leavesBlocks;
    private static Set<Item> choppingToolBlacklistItems;
    public static final ChopSettings fakePlayerChopSettings;
    private static Configuration config;
    private static Stack<String> categoryStack;
    private static final List<Pair<Setting, Boolean>> rawPermissions;
    public static final CommonConfig COMMON;
    public static final ClientConfig CLIENT;

    public static void onReload() {
        ConfigHandler.reload();
        logBlocks = null;
        leavesBlocks = null;
        choppingToolBlacklistItems = null;
        ConfigHandler.updatePermissions();
    }

    private static void updatePermissions() {
        Set<Setting> permittedSettings = rawPermissions.stream().filter(Pair::getRight).map(Pair::getLeft).collect(Collectors.toSet());
        Permissions permissions = new Permissions(permittedSettings);
        Server.updatePermissions(permissions);
    }

    private static void reload() {
        COMMON.reload();
        if (TreeChopMod.proxy instanceof Client) {
            CLIENT.reload();
        }
        fakePlayerChopSettings.setChoppingEnabled(ConfigHandler.COMMON.fakePlayerChoppingEnabled.get());
        fakePlayerChopSettings.setFellingEnabled(ConfigHandler.COMMON.fakePlayerFellingEnabled.get());
        fakePlayerChopSettings.setTreesMustHaveLeaves(ConfigHandler.COMMON.fakePlayerTreesMustHaveLeaves.get());
        ConfigHandler.saveConfig();
    }

    public static void saveConfig() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static String getPrettyValueName(Object value) {
        return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
    }

    private static String getPrettyCategoryName(Object value) {
        return value.toString().replaceAll("([A-Z])", "-$1").toLowerCase();
    }

    private static void pushCategory(String name, String comment) {
        ConfigHandler.pushCategory(name);
        config.setCategoryComment(ConfigHandler.getCategory(), comment);
    }

    private static void pushCategory(String name) {
        categoryStack.push(ConfigHandler.getPrettyCategoryName(name));
    }

    private static void popCategory() {
        categoryStack.pop();
    }

    private static String getCategory() {
        return String.join((CharSequence)".", categoryStack);
    }

    private static List<String> getStringList(String comment, String key, List<String> defaultValues) {
        return Arrays.stream(config.getString(key, ConfigHandler.getCategory(), String.join((CharSequence)LIST_SEPARATOR, defaultValues).concat(LIST_SEPARATOR), comment).split(LIST_SEPARATOR)).map(String::trim).collect(Collectors.toList());
    }

    private static BooleanHandle getBoolean(String key, boolean defaultValue) {
        return ConfigHandler.getBoolean("", key, defaultValue);
    }

    private static BooleanHandle getBoolean(String comment, String key, boolean defaultValue) {
        return new BooleanHandle(ConfigHandler.getCategory(), key, defaultValue, comment);
    }

    private static boolean getRawBoolean(String key, boolean defaultValue) {
        Property prop = config.get(ConfigHandler.getCategory(), key, defaultValue);
        prop.setLanguageKey(key);
        return prop.getBoolean(defaultValue);
    }

    private static int getInt(String comment, String key, int defaultValue, int lowerBound, int upperBound) {
        return config.getInt(key, ConfigHandler.getCategory(), defaultValue, lowerBound, upperBound, comment);
    }

    private static float getFloat(String comment, String key, float defaultValue, float lowerBound, float upperBound) {
        return config.getFloat(key, ConfigHandler.getCategory(), defaultValue, lowerBound, upperBound, comment);
    }

    private static <T extends Enum<T>> EnumHandle<T> getEnum(String comment, String key, T defaultValue, Class<T> enumClass) {
        return new EnumHandle<T>(ConfigHandler.getCategory(), key, defaultValue, comment, enumClass);
    }

    public static void setEnum(String category, String key, Enum<?> value) {
        String valueString = value.name();
        config.get(category, key, valueString).set(valueString);
    }

    public static void load(File configFile) {
        config = new Configuration(configFile, "0.2", false);
        config.load();
        ConfigHandler.onReload();
    }

    private static Set<Item> getLogItems() {
        return CommonConfig.logBlockSynonyms.stream().flatMap(str -> OreDictionary.getOres((String)str).stream()).map(ItemStack::func_77973_b).collect(Collectors.toSet());
    }

    public static Set<Block> getLogBlocks() {
        if (logBlocks == null) {
            logBlocks = CommonConfig.logBlockSynonyms.stream().map(a -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(a))).filter(Objects::nonNull).filter(b -> b != Blocks.field_150350_a).collect(Collectors.toSet());
            Set logItemBlocks = ConfigHandler.getLogItems().stream().filter(item -> item instanceof ItemBlock).map(item -> (ItemBlock)item).map(ItemBlock::func_179223_d).collect(Collectors.toSet());
            logBlocks.addAll(logItemBlocks);
        }
        return logBlocks;
    }

    private static Set<Item> getLeavesItems() {
        return CommonConfig.leavesBlockSynonyms.stream().flatMap(str -> OreDictionary.getOres((String)str).stream()).map(ItemStack::func_77973_b).collect(Collectors.toSet());
    }

    public static Set<Block> getLeavesBlocks() {
        if (leavesBlocks == null) {
            leavesBlocks = CommonConfig.leavesBlockSynonyms.stream().map(a -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(a))).filter(Objects::nonNull).filter(b -> b != Blocks.field_150350_a).collect(Collectors.toSet());
            Set leavesItemBlocks = ConfigHandler.getLeavesItems().stream().filter(item -> item instanceof ItemBlock).map(item -> (ItemBlock)item).map(ItemBlock::func_179223_d).collect(Collectors.toSet());
            leavesBlocks.addAll(leavesItemBlocks);
        }
        return leavesBlocks;
    }

    public static Set<Item> getChoppingToolBlacklistItems() {
        if (choppingToolBlacklistItems == null) {
            choppingToolBlacklistItems = choppingToolBlacklistNames.stream().flatMap(str -> OreDictionary.getOres((String)str).stream()).map(ItemStack::func_77973_b).collect(Collectors.toSet());
            choppingToolBlacklistNames.stream().map(a -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(a))).filter(Objects::nonNull).forEach(choppingToolBlacklistItems::add);
        }
        return choppingToolBlacklistItems;
    }

    public static boolean canChopWithItem(Item item) {
        boolean isListed = ConfigHandler.getChoppingToolBlacklistItems().contains(item);
        if (CommonConfig.blacklistOrWhitelist.get() == ListType.WHITELIST) {
            return isListed;
        }
        return !isListed;
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        logBlocks = null;
        leavesBlocks = null;
        choppingToolBlacklistItems = null;
        fakePlayerChopSettings = new ChopSettings();
        categoryStack = new Stack();
        rawPermissions = new LinkedList<Pair<Setting, Boolean>>();
        COMMON = new CommonConfig();
        CLIENT = new ClientConfig();
    }

    public static class ClientConfig {
        public BooleanHandle choppingEnabled;
        public BooleanHandle fellingEnabled;
        public EnumHandle<SneakBehavior> sneakBehavior;
        public BooleanHandle treesMustHaveLeaves;
        public BooleanHandle chopInCreativeMode;
        public BooleanHandle showChoppingIndicators;
        public int indicatorXOffset;
        public int indicatorYOffset;
        public BooleanHandle showFellingOptions;
        public BooleanHandle showFeedbackMessages;

        public void reload() {
            ConfigHandler.pushCategory("default-player-settings");
            ConfigHandler.pushCategory("chopping");
            this.choppingEnabled = ConfigHandler.getBoolean("Default setting for whether or not the user wishes to chop (can be toggled in-game)", "choppingEnabled", true);
            this.fellingEnabled = ConfigHandler.getBoolean("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)", "fellingEnabled", true);
            this.sneakBehavior = ConfigHandler.getEnum("Default setting for the effect that sneaking has on chopping (can be cycled in-game)", "sneakBehavior", SneakBehavior.INVERT_CHOPPING, SneakBehavior.class);
            this.treesMustHaveLeaves = ConfigHandler.getBoolean("Whether to ignore trees without connected leaves", "treesMustHaveLeaves", true);
            this.chopInCreativeMode = ConfigHandler.getBoolean("Whether to enable chopping when in creative mode (even when false, sneaking can still enable chopping)", "chopInCreativeMode", true);
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("visuals");
            ConfigHandler.pushCategory("chopping-indicator");
            this.showChoppingIndicators = ConfigHandler.getBoolean("Whether to show an on-screen icon indicating whether targeted blocks can be chopped", "enabled", true);
            this.indicatorXOffset = ConfigHandler.getInt("Horizontal location of the indicator relative to the player's crosshairs; positive values move the indicator to the right", "xOffset", 16, -256, 256);
            this.indicatorYOffset = ConfigHandler.getInt("Vertical location of the indicator relative to the player's crosshairs; positive values move the indicator down", "yOffset", 0, -256, 256);
            ConfigHandler.popCategory();
            ConfigHandler.popCategory();
            if (Minecraft.func_71410_x().field_71441_e != null) {
                Client.updateChopSettings();
            }
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("settings-screen");
            this.showFellingOptions = ConfigHandler.getBoolean("Whether to show in-game options for enabling and disable felling", "showFellingOptions", false);
            this.showFeedbackMessages = ConfigHandler.getBoolean("Whether to show chat confirmations when using hotkeys to change chop settings", "showFeedbackMessages", true);
            ConfigHandler.popCategory();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled(this.choppingEnabled.get());
            chopSettings.setFellingEnabled(this.fellingEnabled.get());
            chopSettings.setSneakBehavior(this.sneakBehavior.get());
            chopSettings.setTreesMustHaveLeaves(this.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode(this.chopInCreativeMode.get());
            return chopSettings;
        }
    }

    public static class CommonConfig {
        public BooleanHandle enabled;
        public int maxNumTreeBlocks;
        public int maxNumLeavesBlocks;
        public BooleanHandle breakLeaves;
        public BooleanHandle ignorePersistentLeaves;
        public int maxBreakLeavesDistance;
        private static List<String> logBlockSynonyms;
        private static List<String> leavesBlockSynonyms;
        public EnumHandle<ChopCountingAlgorithm> chopCountingAlgorithm;
        public EnumHandle<Rounder> chopCountRounding;
        public BooleanHandle canRequireMoreChopsThanBlocks;
        public float logarithmicA;
        public float linearM;
        public float linearB;
        public static EnumHandle<ListType> blacklistOrWhitelist;
        public BooleanHandle preventChopRecursion;
        public BooleanHandle preventChoppingOnRightClick;
        public BooleanHandle compatForProjectMMO;
        public BooleanHandle fakePlayerChoppingEnabled;
        public BooleanHandle fakePlayerFellingEnabled;
        public BooleanHandle fakePlayerTreesMustHaveLeaves;

        public void reload() {
            ConfigHandler.pushCategory("permissions");
            this.enabled = ConfigHandler.getBoolean("Whether this mod is enabled or not", "enabled", true);
            rawPermissions.clear();
            for (SettingsField field : SettingsField.values()) {
                String fieldName = field.getConfigKey();
                ConfigHandler.pushCategory(fieldName);
                for (Object value : field.getValues()) {
                    String valueName = ConfigHandler.getPrettyValueName(value);
                    boolean permitted = ConfigHandler.getRawBoolean("canBe" + valueName, true);
                    rawPermissions.add(Pair.of((Object)new Setting(field, value), (Object)permitted));
                }
                ConfigHandler.popCategory();
            }
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("tree-detection");
            this.maxNumTreeBlocks = ConfigHandler.getInt("Maximum number of log block that can be detected to belong to one tree", "maxNumTreeBlocks", 512, 1, 8096);
            this.maxNumLeavesBlocks = ConfigHandler.getInt("Maximum number of leaves block that can destroyed when a tree is felled", "maxNumLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = ConfigHandler.getBoolean("Whether to destroy leaves when a tree is felled", "breakLeaves", true);
            this.ignorePersistentLeaves = ConfigHandler.getBoolean("Whether non-decayable leaves are ignored when detecting leaves", "ignorePersistentLeaves", true);
            this.maxBreakLeavesDistance = ConfigHandler.getInt("Maximum distance from tree blocks to destroy leaves blocks when felling (Note: smart leaves destruction is not supported in 1.12.2)", "maxBreakLeavesDistance", 4, 0, 16);
            logBlockSynonyms = ConfigHandler.getStringList("Comma-separated list of blocks that can be chopped\nOre dictionary names are also acceptable", "logBlocks", Lists.newArrayList((Object[])new String[]{"logWood"}));
            leavesBlockSynonyms = ConfigHandler.getStringList("Comma-separated list of blocks that are automatically broken when attached to a felled tree and breakLeaves=true\nOre dictionary names are also acceptable", "leavesBlocks", Lists.newArrayList((Object[])new String[]{"treeLeaves"}));
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("chop-counting");
            this.chopCountingAlgorithm = ConfigHandler.getEnum("Method to use for computing the number of chops needed to fell a tree", "algorithm", ChopCountingAlgorithm.LOGARITHMIC, ChopCountingAlgorithm.class);
            this.chopCountRounding = ConfigHandler.getEnum("How to round the number of chops needed to fell a tree; this is more meaningful for smaller trees", "rounding", Rounder.NEAREST, Rounder.class);
            this.canRequireMoreChopsThanBlocks = ConfigHandler.getBoolean("Whether felling a tree can require more chops than the number of blocks in the tree", "canRequireMoreChopsThanBlocks", false);
            ConfigHandler.pushCategory("logarithmic", "See https://github.com/hammertater/treechop/#logarithmic");
            this.logarithmicA = ConfigHandler.getFloat("Determines the number of chops required to fell a tree; higher values require more chops for bigger trees", "a", 10.0f, 0.0f, 10000.0f);
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("linear", "See https://github.com/hammertater/treechop/#linear");
            this.linearM = ConfigHandler.getFloat("The number of chops per block required to fell a tree; if chopsPerBlock = 0.5, it will take 50 chops to fell a 100 block tree", "chopsPerBlock", 1.0f, 0.0f, 7.0f);
            this.linearB = ConfigHandler.getFloat("The base number of chops required to fell a tree regardless of its size", "baseNumChops", 0.0f, -10000.0f, 10000.0f);
            ConfigHandler.popCategory();
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("compatibility");
            ConfigHandler.pushCategory("general");
            this.preventChopRecursion = ConfigHandler.getBoolean("Whether to prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks", "preventChopRecursion", true);
            this.preventChoppingOnRightClick = ConfigHandler.getBoolean("Whether to prevent chopping during right-click actions", "preventChoppingOnRightClick", false);
            ConfigHandler.pushCategory("blacklist");
            blacklistOrWhitelist = ConfigHandler.getEnum("Whether the listed items should be blacklisted or whitelisted", "blacklistOrWhitelist", ListType.BLACKLIST, ListType.class);
            choppingToolBlacklistNames = ConfigHandler.getStringList("Comma-separated list of items that should not chop when used to break a log\nOre dictionary names are also acceptable", "choppingToolsBlacklist", Lists.newArrayList((Object[])new String[]{"mekanism:atomic_disassembler"}));
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("fakePlayerChopSettings", "The chop settings used by non-player entities, such as robots");
            this.fakePlayerChoppingEnabled = ConfigHandler.getBoolean("Use with caution! May cause conflicts with some mods, e.g. https://github.com/hammertater/treechop/issues/71", "choppingEnabled", false);
            this.fakePlayerFellingEnabled = ConfigHandler.getBoolean("Felling only matters if chopping is enabled; probably best to leave this on", "fellingEnabled", true);
            this.fakePlayerTreesMustHaveLeaves = ConfigHandler.getBoolean("treesMustHaveLeaves", true);
            ConfigHandler.popCategory();
            ConfigHandler.pushCategory("specific");
            this.compatForProjectMMO = ConfigHandler.getBoolean(String.join((CharSequence)"\n", "Whether to enable compatibility with ProjectMMO; for example, award XP for chopping", "See https://www.curseforge.com/minecraft/mc-mods/project-mmo"), "projectMMO", true);
            ConfigHandler.popCategory();
            ConfigHandler.popCategory();
            ConfigHandler.popCategory();
        }
    }
}

