/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.widget;

import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.gui.widget.Widget;
import java.util.EnumMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class ToggleWidget
extends Widget {
    private final Supplier<State> stateSupplier;
    private final Runnable onPress;

    public ToggleWidget(int x, int y, Runnable onPress, Supplier<State> stateSupplier) {
        super(x, y, Sprite.TOGGLE_BUTTON_OFF.width, Sprite.TOGGLE_BUTTON_OFF.height);
        this.onPress = onPress;
        this.stateSupplier = stateSupplier;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.active = !this.stateSupplier.get().isLocked;
        this.renderButton(mouseX, mouseY, partialTicks);
    }

    @Override
    public void onClick(int mouseX, int mouseY, int button) {
        this.onPress.run();
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Sprite.setRenderState(1.0f);
        EnumMap<State, Sprite> spriteForState = new EnumMap<State, Sprite>(Stream.of(Pair.of((Object)((Object)State.OFF), (Object)((Object)Sprite.TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.ON), (Object)((Object)Sprite.TOGGLE_BUTTON_ON)), Pair.of((Object)((Object)State.LOCKED_OFF), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.LOCKED_ON), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_ON))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        EnumMap<State, Sprite> spriteForHoveredState = new EnumMap<State, Sprite>(Stream.of(Pair.of((Object)((Object)State.OFF), (Object)((Object)Sprite.HIGHLIGHTED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.ON), (Object)((Object)Sprite.HIGHLIGHTED_TOGGLE_BUTTON_ON)), Pair.of((Object)((Object)State.LOCKED_OFF), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.LOCKED_ON), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_ON))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        State state = this.stateSupplier.get();
        Sprite sprite = this.isHovered() ? spriteForHoveredState.get((Object)state) : spriteForState.get((Object)state);
        sprite.blit(this.getBox().getLeft(), this.getBox().getTop());
    }

    public static enum State {
        ON(true, false),
        OFF(false, false),
        LOCKED_ON(true, true),
        LOCKED_OFF(false, true);

        public final boolean isOn;
        private final boolean isLocked;

        private State(boolean isOn, boolean isLocked) {
            this.isOn = isOn;
            this.isLocked = isLocked;
        }

        public static State of(boolean enabled, boolean canBeEnabled) {
            if (canBeEnabled) {
                return enabled ? ON : OFF;
            }
            return enabled ? LOCKED_ON : LOCKED_OFF;
        }
    }
}

