/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import ht.treechop.client.Client;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ChopIndicator {
    private static final double IMAGE_SCALE = 1.0;
    private static BlockPos lastBlockPos = null;
    private static final ChopSettings lastChopSettings = new ChopSettings();
    private static boolean lastBlockWouldBeChopped = false;

    public void render(float partialTicks, ScaledResolution resolution) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RayTraceResult mouseOver = minecraft.field_71476_x;
        if (Client.isChoppingIndicatorEnabled() && minecraft.field_71462_r == null && mouseOver != null && mouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = mouseOver.func_178782_a();
            if (this.blockWouldBeChopped(blockPos)) {
                int windowWidth = resolution.func_78326_a();
                int windowHeight = resolution.func_78328_b();
                minecraft.func_110434_K().func_110577_a(Sprite.TEXTURE_PATH);
                int indicatorCenterX = windowWidth / 2 + ConfigHandler.CLIENT.indicatorXOffset;
                int indicatorCenterY = windowHeight / 2 + ConfigHandler.CLIENT.indicatorYOffset;
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Sprite sprite = ChopUtil.playerWantsToFell((EntityPlayer)minecraft.field_71439_g, Client.getChopSettings()) ? Sprite.CHOP_INDICATOR : Sprite.NO_FELL_INDICATOR;
                int imageWidth = (int)((double)sprite.width * 1.0);
                int imageHeight = (int)((double)sprite.height * 1.0);
                sprite.blit(indicatorCenterX - imageWidth / 2, indicatorCenterY - imageHeight / 2, imageWidth, imageHeight);
            }
            lastBlockPos = blockPos;
            lastChopSettings.copyFrom(Client.getChopSettings());
        } else {
            lastBlockPos = null;
        }
    }

    private boolean blockWouldBeChopped(BlockPos pos) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        WorldClient world = minecraft.field_71441_e;
        if (world != null & minecraft.field_71439_g != null && ChopUtil.canChopWithTool(player.func_184614_ca()) && ChopUtil.playerWantsToChop((EntityPlayer)minecraft.field_71439_g, Client.getChopSettings())) {
            if (pos.equals((Object)lastBlockPos) || !Client.getChopSettings().equals(lastChopSettings)) {
                lastBlockWouldBeChopped = ChopUtil.playerWantsToFell((EntityPlayer)player, Client.getChopSettings()) ? ChopUtil.isPartOfATree((World)world, pos, Client.getChopSettings().getTreesMustHaveLeaves()) : ChopUtil.isBlockALog((World)world, pos);
            }
        } else {
            lastBlockWouldBeChopped = false;
        }
        return lastBlockWouldBeChopped;
    }
}

