/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.dynamicresources.DeferredListeners;
import org.embeddedt.vintagefix.dynamicresources.EventUtil;
import org.embeddedt.vintagefix.dynamicresources.ItemBakeThread;
import org.embeddedt.vintagefix.dynamicresources.ResourcePackHelper;
import org.embeddedt.vintagefix.dynamicresources.SafeModelBakeWrapper;
import org.embeddedt.vintagefix.dynamicresources.TextureCollector;
import org.embeddedt.vintagefix.dynamicresources.WrappingModelRegistry;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicBakedModelProvider;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicModelProvider;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelManager.class})
@ClientOnlyMixin
public class MixinModelManager {
    @Shadow
    private IRegistry<ModelResourceLocation, IBakedModel> field_174958_a;
    @Shadow
    private IBakedModel field_174955_d;
    @Shadow
    @Final
    private BlockModelShapes field_174957_c;
    @Shadow
    @Final
    private TextureMap field_174956_b;
    private Set<ResourceLocation> earlyDetectedTextures;
    private Map<ModelResourceLocation, IModel> blackListedModels;

    private void doEarlyModelLoading(IResourceManager manager) {
        Predicate<String> shouldLoadEarly = p -> {
            if (p.length() < 6) {
                return false;
            }
            String customName = p.substring(0, p.length() - 5);
            return (customName.endsWith("tmat") || customName.endsWith("tcon") || customName.endsWith("mod") || customName.endsWith("conarm")) && p.endsWith(".json");
        };
        Predicate<String> shouldPersistEarly = p -> p.endsWith(".tmat.json");
        Collection<String> earlyModelPaths = ResourcePackHelper.getAllPaths((SimpleReloadableResourceManager)manager, shouldLoadEarly);
        VintageFix.LOGGER.info("Early loading {} models", (Object)earlyModelPaths.size());
        int permLoaded = 0;
        for (String path : earlyModelPaths) {
            ResourceLocation rl = ResourcePackHelper.pathToResourceLocation(path, ResourcePackHelper.ResourceLocationMatchType.SHORT);
            if (rl != null) {
                try {
                    IModel theModel = DynamicModelProvider.instance.getObject(rl);
                    if (theModel != null) {
                        try {
                            this.earlyDetectedTextures.addAll(theModel.getTextures());
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (theModel == null || !shouldPersistEarly.test(path)) continue;
                    DynamicModelProvider.instance.putObject(rl, theModel);
                    ++permLoaded;
                }
                catch (Exception e) {
                    VintageFix.LOGGER.error("Early load error for {}", (Object)rl, (Object)e);
                }
                continue;
            }
            VintageFix.LOGGER.warn("Path {} is not a valid model location", (Object)path);
        }
        VintageFix.LOGGER.info("Permanently loaded {} models", (Object)permLoaded);
    }

    private boolean shouldLoadBlacklisted(ModelResourceLocation mrl) {
        return mrl.func_110624_b().equals("thebetweenlands") || mrl.func_110624_b().equals("dynamictrees");
    }

    private boolean shouldPersistBlacklisted(ResourceLocation mrl) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void doBlacklistedModelLoading(IResourceManager manager) {
        void var4_8;
        this.blackListedModels = new Object2ObjectOpenHashMap();
        ArrayList<Object> modelList = new ArrayList<Object>();
        for (ModelResourceLocation modelResourceLocation : ModelLocationInformation.inventoryVariantLocations.keySet()) {
            if (!this.shouldLoadBlacklisted(modelResourceLocation)) continue;
            modelList.add(modelResourceLocation);
        }
        for (Collection collection : ModelLocationInformation.validVariantsForBlock.values()) {
            for (ModelResourceLocation modelResourceLocation : collection) {
                if (!this.shouldLoadBlacklisted(modelResourceLocation)) continue;
                modelList.add(modelResourceLocation);
            }
        }
        if (Loader.isModLoaded((String)"gbook")) {
            modelList.add(new ResourceLocation("gbook", "block/custom/book"));
        }
        if (modelList.size() == 0) {
            return;
        }
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Incompatible model loading", (int)modelList.size());
        boolean bl = false;
        for (ResourceLocation resourceLocation : modelList) {
            bar.step(resourceLocation.toString());
            try {
                IModel model = DynamicModelProvider.instance.getObject(resourceLocation);
                if (model == null) continue;
                try {
                    this.earlyDetectedTextures.addAll(model.getTextures());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (this.shouldPersistBlacklisted(resourceLocation)) {
                    DynamicModelProvider.instance.putObject(resourceLocation, model);
                }
                if (!(resourceLocation instanceof ModelResourceLocation)) continue;
                this.blackListedModels.put((ModelResourceLocation)resourceLocation, model);
            }
            catch (RuntimeException e) {
                VintageFix.LOGGER.error("Error loading blacklisted model {}: {}", (Object)resourceLocation, (Object)e);
                ++var4_8;
            }
        }
        VintageFix.LOGGER.info("{}/{} models had errors loading", (Object)((int)var4_8), (Object)modelList.size());
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    private void doBlacklistedModelBaking(IResourceManager manager) {
        if (this.blackListedModels.size() > 0) {
            ProgressManager.ProgressBar bar = ProgressManager.push((String)"Incompatible model baking", (int)this.blackListedModels.size());
            for (Map.Entry<ModelResourceLocation, IModel> entry : this.blackListedModels.entrySet()) {
                bar.step(entry.getKey().toString());
                try {
                    IBakedModel model = DynamicBakedModelProvider.instance.getObject(entry.getKey());
                    if (!this.shouldPersistBlacklisted((ResourceLocation)entry.getKey())) continue;
                    DynamicBakedModelProvider.instance.putObject(entry.getKey(), model);
                }
                catch (RuntimeException e) {
                    VintageFix.LOGGER.error("Error baking blacklisted model {}: {}", (Object)entry.getKey(), (Object)e);
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
        }
        this.blackListedModels = null;
    }

    @Overwrite
    public void func_110549_a(IResourceManager resourceManager) {
        DynamicBakedModelProvider dynamicBakedModelProvider;
        DynamicModelProvider dynamicModelProvider;
        Set loaders;
        TextureCollector.startDiscovery();
        ItemBakeThread.stopAndJoin();
        for (IResourceManagerReloadListener listener : DeferredListeners.deferredListeners) {
            listener.func_110549_a(resourceManager);
        }
        ModelLoader loader = new ModelLoader(resourceManager, this.field_174956_b, this.field_174957_c);
        ProgressManager.ProgressBar overallBar = ProgressManager.push((String)"Setting up dynamic models", (int)5);
        overallBar.step("Generate model locations");
        ModelLocationInformation.init(loader, this.field_174957_c.func_178120_a());
        try {
            Field loadersField = ModelLoaderRegistry.class.getDeclaredField("loaders");
            loadersField.setAccessible(true);
            loaders = (Set)loadersField.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        DynamicModelProvider.instance = dynamicModelProvider = new DynamicModelProvider(loaders);
        DynamicBakedModelProvider.instance = dynamicBakedModelProvider = new DynamicBakedModelProvider(dynamicModelProvider);
        this.field_174958_a = dynamicBakedModelProvider;
        SafeModelBakeWrapper.theManager = (ModelManager)this;
        this.earlyDetectedTextures = new HashSet<ResourceLocation>();
        overallBar.step("Early model loading");
        this.doEarlyModelLoading(resourceManager);
        overallBar.step("Blacklisted model loading");
        this.doBlacklistedModelLoading(resourceManager);
        Method getTexturesMethod = ObfuscationReflectionHelper.findMethod(ModelLoaderRegistry.class, (String)"getTextures", Iterable.class, (Class[])new Class[0]);
        try {
            getTexturesMethod.setAccessible(true);
            Iterable registryTextures = (Iterable)getTexturesMethod.invoke(null, new Object[0]);
            registryTextures.forEach(this.earlyDetectedTextures::add);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.earlyDetectedTextures.remove(TextureMap.field_174945_f);
        this.earlyDetectedTextures.addAll((Collection)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, null, (String)"field_177602_b"));
        overallBar.step("Load textures");
        this.field_174956_b.func_174943_a(resourceManager, map -> this.earlyDetectedTextures.forEach(arg_0 -> ((TextureMap)map).func_174942_a(arg_0)));
        this.field_174955_d = (IBakedModel)this.field_174958_a.func_82594_a((Object)DynamicBakedModelProvider.MISSING_MODEL_LOCATION);
        if (this.field_174955_d == null) {
            throw new AssertionError((Object)"Missing model is missing");
        }
        DynamicBakedModelProvider.missingModel = this.field_174955_d;
        this.doBlacklistedModelBaking(resourceManager);
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition((Item)ForgeModContainer.getInstance().universalBucket);
        }
        ModelBakeEvent event = new ModelBakeEvent((ModelManager)this, (IRegistry)new WrappingModelRegistry(this.field_174958_a), loader);
        IEventListener[] listeners = EventUtil.getListenersForEvent((Event)event);
        overallBar.step("Baking");
        ProgressManager.ProgressBar bakeEventBar = ProgressManager.push((String)"Posting bake events", (int)listeners.length);
        for (IEventListener listener : listeners) {
            bakeEventBar.step(listener.toString());
            try {
                listener.invoke((Event)event);
            }
            catch (Throwable t) {
                VintageFix.LOGGER.error(event + " listener '" + listener + "' threw exception, models may be broken", t);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bakeEventBar);
        ProgressManager.pop((ProgressManager.ProgressBar)overallBar);
        this.field_174957_c.func_178124_c();
        this.earlyDetectedTextures = new HashSet<ResourceLocation>();
    }
}

