/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap.table;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import org.embeddedt.vintagefix.ducks.FastMapStateHolder;
import org.embeddedt.vintagefix.fastmap.FastMap;
import org.embeddedt.vintagefix.fastmap.table.NeighborTableBase;

public class FastmapNeighborTable<S>
extends NeighborTableBase<S> {
    private final FastMapStateHolder<S> owner;

    public FastmapNeighborTable(FastMapStateHolder<S> owner) {
        this.owner = owner;
    }

    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (!(columnKey instanceof Comparable) || !(rowKey instanceof IProperty)) {
            return false;
        }
        Object valueInState = this.owner.getStateMap().getValue(this.owner.getStateIndex(), (IProperty)rowKey);
        if (valueInState == null || valueInState.equals(columnKey)) {
            return false;
        }
        return ((IProperty)rowKey).func_177700_c().contains(columnKey);
    }

    public boolean containsRow(@Nullable Object rowKey) {
        if (!(rowKey instanceof IProperty)) {
            return false;
        }
        return this.owner.getStateMap().getValue(this.owner.getStateIndex(), (IProperty)rowKey) != null;
    }

    public boolean containsColumn(@Nullable Object columnKey) {
        FastMap<S> map = this.owner.getStateMap();
        for (int i = 0; i < map.numProperties(); ++i) {
            Map.Entry<IProperty<?>, Comparable<?>> entry = map.getEntry(i, this.owner.getStateIndex());
            if (entry.getValue().equals(columnKey) || !entry.getKey().func_177700_c().contains(columnKey)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        FastMap<S> map = this.owner.getStateMap();
        for (int propIndex = 0; propIndex < map.numProperties(); ++propIndex) {
            if (!this.isNeighbor(map.getKey(propIndex).getProperty(), value)) continue;
            return true;
        }
        return false;
    }

    private <T extends Comparable<T>> boolean isNeighbor(IProperty<T> prop, Object potentialNeighbor) {
        FastMap<S> map = this.owner.getStateMap();
        T valueInState = map.getValue(this.owner.getStateIndex(), prop);
        for (Comparable neighborValue : prop.func_177700_c()) {
            S neighbor;
            if (neighborValue.equals(valueInState) || !potentialNeighbor.equals(neighbor = map.with(this.owner.getStateIndex(), prop, valueInState))) continue;
            return true;
        }
        return false;
    }

    public S get(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (!(rowKey instanceof IProperty)) {
            return null;
        }
        return this.owner.getStateMap().withUnsafe(this.owner.getStateIndex(), (IProperty)rowKey, columnKey);
    }

    public boolean isEmpty() {
        return this.owner.getStateMap().isSingleState();
    }

    public int size() {
        int numNeighbors = 0;
        for (int i = 0; i < this.owner.getStateMap().numProperties(); ++i) {
            numNeighbors += this.owner.getStateMap().getKey(i).numValues();
        }
        return numNeighbors;
    }

    public Map<Comparable<?>, S> row(@Nonnull IProperty<?> rowKey) {
        HashMap<Comparable, S> rowMap = new HashMap<Comparable, S>();
        Object contained = this.owner.getStateMap().getValue(this.owner.getStateIndex(), rowKey);
        for (Comparable val : rowKey.func_177700_c()) {
            if (val.equals(contained)) continue;
            rowMap.put(val, this.owner.getStateMap().withUnsafe(this.owner.getStateIndex(), rowKey, val));
        }
        return rowMap;
    }

    public Map<IProperty<?>, S> column(@Nonnull Comparable<?> columnKey) {
        FastMap<S> map = this.owner.getStateMap();
        int index = this.owner.getStateIndex();
        HashMap rowMap = new HashMap();
        for (int i = 0; i < map.numProperties(); ++i) {
            IProperty<?> rowKey = map.getKey(i).getProperty();
            Object contained = map.getValue(index, rowKey);
            for (Comparable val : rowKey.func_177700_c()) {
                if (val.equals(contained) || !val.equals(columnKey)) continue;
                rowMap.put(rowKey, map.withUnsafe(index, rowKey, val));
            }
        }
        return rowMap;
    }

    public Set<Table.Cell<IProperty<?>, Comparable<?>, S>> cellSet() {
        FastMap<S> map = this.owner.getStateMap();
        int index = this.owner.getStateIndex();
        HashSet rowMap = new HashSet();
        for (int i = 0; i < map.numProperties(); ++i) {
            IProperty<?> rowKey = map.getKey(i).getProperty();
            Object contained = map.getValue(index, rowKey);
            for (Comparable val : rowKey.func_177700_c()) {
                if (val.equals(contained)) continue;
                rowMap.add(Tables.immutableCell(rowKey, (Object)val, map.withUnsafe(index, rowKey, val)));
            }
        }
        return rowMap;
    }

    public Set<IProperty<?>> rowKeySet() {
        return this.owner.getVanillaPropertyMap().keySet();
    }

    public Set<Comparable<?>> columnKeySet() {
        FastMap<S> map = this.owner.getStateMap();
        HashSet rowMap = new HashSet();
        for (int i = 0; i < map.numProperties(); ++i) {
            IProperty<?> rowKey = map.getKey(i).getProperty();
            Object contained = map.getValue(this.owner.getStateIndex(), rowKey);
            for (Comparable val : rowKey.func_177700_c()) {
                if (val.equals(contained)) continue;
                rowMap.add(val);
            }
        }
        return rowMap;
    }

    public Collection<S> values() {
        FastMap<S> map = this.owner.getStateMap();
        int index = this.owner.getStateIndex();
        HashSet<S> rowMap = new HashSet<S>();
        for (int i = 0; i < map.numProperties(); ++i) {
            IProperty<?> rowKey = map.getKey(i).getProperty();
            Object contained = map.getValue(index, rowKey);
            for (Comparable val : rowKey.func_177700_c()) {
                if (val.equals(contained)) continue;
                rowMap.add(map.withUnsafe(index, rowKey, val));
            }
        }
        return rowMap;
    }

    public Map<IProperty<?>, Map<Comparable<?>, S>> rowMap() {
        FastMap<S> map = this.owner.getStateMap();
        HashMap rowMap = new HashMap();
        for (int i = 0; i < map.numProperties(); ++i) {
            IProperty<?> rowKey = map.getKey(i).getProperty();
            rowMap.put(rowKey, this.row(rowKey));
        }
        return rowMap;
    }

    public Map<Comparable<?>, Map<IProperty<?>, S>> columnMap() {
        Map<IProperty<?>, Map<Comparable<?>, S>> rowMap = this.rowMap();
        HashMap colMap = new HashMap();
        for (Map.Entry<IProperty<?>, Map<Comparable<?>, S>> entry : rowMap.entrySet()) {
            for (Map.Entry<Comparable<?>, S> innerEntry : entry.getValue().entrySet()) {
                colMap.computeIfAbsent(innerEntry.getKey(), $ -> new HashMap()).put(entry.getKey(), innerEntry.getValue());
            }
        }
        return colMap;
    }
}

