/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.VintageFixClient;
import org.embeddedt.vintagefix.dynamicresources.ResourcePackHelper;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.embeddedt.vintagefix.util.Util;

public class TextureCollector {
    private static final Pattern TEXTURE_MATCH_PATTERN = Pattern.compile("^/?assets/(.+?(?=/))/textures/((?:attachment|aspect.?|bettergrass|block.?|cape|customoverlay|decors|item.?|entity/(armor|bed|chest)|fluid.?|model.?|part.?|pipe|rendering|ropebridge|slot.?|solid_block|tile.?|tinkers|tconstruct|valuetype.?)/.*)\\.png$");
    private static final ImmutableListMultimap<String, ResourceLocation> EXTRA_TEXTURES_BY_MOD = ImmutableListMultimap.builder().put((Object)"mekanism", (Object)new ResourceLocation("mekanism", "entities/robit")).put((Object)"gbook", (Object)new ResourceLocation("gbook", "cover")).put((Object)"gbook", (Object)new ResourceLocation("gbook", "cover_gray")).put((Object)"gbook", (Object)new ResourceLocation("gbook", "paper")).put((Object)"gbook", (Object)new ResourceLocation("gbook", "transparent")).build();
    List<IResourcePack> resourcePackList;
    public static Set<String> weaklyCollectedTextures = ImmutableSet.of();
    Set<ResourceLocation> lookedAtLocations = Collections.synchronizedSet(new ObjectOpenHashSet());
    Map<ResourceLocation, Boolean> doesResourceExist = new ConcurrentHashMap<ResourceLocation, Boolean>();
    private static final Pattern JSON_TEXTURE_MATCHER = Pattern.compile("\"(?:([A-Za-z0-9_\\-.]+):|)([A-za-z0-9_\\-./]+)\"");

    TextureCollector() {
        this.resourcePackList = VintageFixClient.getResourcePackList();
    }

    public static void startDiscovery() {
        TextureCollector collector = new TextureCollector();
        VintageFixClient.discoveredTextures = VintageFix.WORKER_POOL.submit(collector::getAllTextureLocations);
    }

    Set<ResourceLocation> getAllTextureLocations() {
        HashSet<ResourceLocation> allTextures = new HashSet<ResourceLocation>();
        Stopwatch watch = Stopwatch.createStarted();
        Future modelTextures = VintageFix.WORKER_POOL.submit(this::collectModelTextures);
        int numFoundSprites = 0;
        UnmodifiableIterator gameFolders = new UnmodifiableIterator[]{"resources", "oresources"};
        for (IResourcePack pack : this.resourcePackList) {
            try {
                Collection<String> paths = ResourcePackHelper.getAllPaths(pack, s -> true);
                for (String path2 : paths) {
                    Matcher matcher = TEXTURE_MATCH_PATTERN.matcher(path2);
                    if (!matcher.matches()) continue;
                    allTextures.add(new ResourceLocation(matcher.group(1), matcher.group(2)));
                    ++numFoundSprites;
                }
            }
            catch (IOException e) {
                VintageFix.LOGGER.error("Error listing resources", (Throwable)e);
            }
        }
        VintageFix.LOGGER.info("Found {} sprites (some possibly duplicated among resource packs)", (Object)numFoundSprites);
        Path gameDirPath = Minecraft.func_71410_x().field_71412_D.toPath();
        for (String gameFolder : gameFolders) {
            Path base = gameDirPath.resolve(gameFolder);
            try (Stream<Path> stream2 = Files.walk(base, new FileVisitOption[0]);){
                Iterator iterator = stream2.map(base::relativize).map(path -> "assets/" + Util.normalizePathToString(path)).iterator();
                while (iterator.hasNext()) {
                    String p = (String)iterator.next();
                    Matcher matcher = TEXTURE_MATCH_PATTERN.matcher(p);
                    if (!matcher.matches()) continue;
                    allTextures.add(new ResourceLocation(matcher.group(1), matcher.group(2)));
                    ++numFoundSprites;
                }
            }
            catch (FileNotFoundException | NoSuchFileException stream2) {
            }
            catch (IOException e) {
                VintageFix.LOGGER.error("Error listing resources", (Throwable)e);
            }
        }
        for (Map.Entry entry : EXTRA_TEXTURES_BY_MOD.entries()) {
            allTextures.add((ResourceLocation)entry.getValue());
            ++numFoundSprites;
        }
        for (ResourceLocation location : (List)((ForkJoinTask)modelTextures).join()) {
            allTextures.add(location);
            ++numFoundSprites;
        }
        watch.stop();
        VintageFix.LOGGER.info("Texture search took {}, total of {} collected sprites", (Object)watch, (Object)numFoundSprites);
        return allTextures;
    }

    private boolean resourceExists(ResourceLocation loc) {
        return this.doesResourceExist.computeIfAbsent(loc, rl -> {
            try (IResource ignored1 = Minecraft.func_71410_x().func_110442_L().func_110536_a(rl);){
                Boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    private List<ResourceLocation> collectModelTextures() {
        ModelLocationInformation.initFuture.join();
        ObjectOpenHashSet allBlockstates = new ObjectOpenHashSet();
        Consumer<ModelResourceLocation> adder = mrl -> allBlockstates.add((Object)new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a()));
        ModelLocationInformation.allItemVariants.forEach(adder);
        for (Collection<ModelResourceLocation> collection : ModelLocationInformation.validVariantsForBlock.values()) {
            collection.forEach(adder);
        }
        ArrayList<CompletableFuture<List>> results = new ArrayList<CompletableFuture<List>>();
        for (ResourceLocation location : allBlockstates) {
            results.add(CompletableFuture.supplyAsync(() -> {
                ResourceLocation blockstateLocation = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
                return this.collectJsonTexture(blockstateLocation);
            }, VintageFix.WORKER_POOL));
        }
        for (ResourceLocation location : ModelLocationInformation.inventoryVariantLocations.values()) {
            results.add(CompletableFuture.supplyAsync(() -> {
                ResourceLocation modelLocation = new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
                return this.collectJsonTexture(modelLocation);
            }, VintageFix.WORKER_POOL));
        }
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).join();
        ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
        for (CompletableFuture completableFuture : results) {
            List list = (List)completableFuture.join();
            objectOpenHashSet.addAll(list);
        }
        this.lookedAtLocations.clear();
        this.doesResourceExist.clear();
        return new ArrayList<ResourceLocation>((Collection<ResourceLocation>)objectOpenHashSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ResourceLocation> collectJsonTexture(ResourceLocation jsonLocation) {
        if (!this.lookedAtLocations.add(jsonLocation)) {
            return ImmutableList.of();
        }
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        try (IResource resource2222 = manager.func_110536_a(jsonLocation);){
            InputStream stream = resource2222.func_110527_b();
            String str = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            Matcher matcher = JSON_TEXTURE_MATCHER.matcher(str);
            ArrayList<ResourceLocation> textureLoc = new ArrayList<ResourceLocation>();
            while (matcher.find()) {
                String namespace = matcher.group(1);
                if (namespace == null) {
                    namespace = "minecraft";
                }
                String path = matcher.group(2);
                if (this.resourceExists(new ResourceLocation(namespace, "textures/" + path + ".png"))) {
                    ResourceLocation realLocation = new ResourceLocation(namespace, path);
                    textureLoc.add(realLocation);
                    continue;
                }
                ResourceLocation modelLocation = new ResourceLocation(namespace, "models/block/" + path + ".json");
                if (this.resourceExists(modelLocation)) {
                    textureLoc.addAll(this.collectJsonTexture(modelLocation));
                    continue;
                }
                modelLocation = new ResourceLocation(namespace, "models/" + path + ".json");
                if (!this.resourceExists(modelLocation)) continue;
                textureLoc.addAll(this.collectJsonTexture(modelLocation));
            }
            if (textureLoc.size() <= 0) return ImmutableList.of();
            ArrayList<ResourceLocation> arrayList = textureLoc;
            return arrayList;
        }
        catch (FileNotFoundException resource2222) {
            return ImmutableList.of();
        }
        catch (Throwable e) {
            VintageFix.LOGGER.error("Exception reading JSON for {}", (Object)jsonLocation, (Object)e);
        }
        return ImmutableList.of();
    }
}

