/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.core;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.embeddedt.vintagefix.jarcache.JarDiscovererCache;
import org.embeddedt.vintagefix.util.DummyList;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import zone.rong.mixinbooter.IEarlyMixinLoader;

@IFMLLoadingPlugin.Name(value="VintageFix")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class VintageFixCore
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static boolean OPTIFINE;
    private static boolean mixinFixApplied;

    public VintageFixCore() {
        try {
            Class<?> transformerClass = Class.forName("zone.rong.loliasm.core.LoliTransformer");
            Field field = transformerClass.getDeclaredField("squashBakedQuads");
            field.setAccessible(true);
            field.setBoolean(null, false);
            System.out.println("Disabled squashBakedQuads due to compatibility issues, please ask Rongmario to fix this someday");
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{"org.embeddedt.vintagefix.transformer.ASMModParserTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        if (JarDiscovererCache.isActive()) {
            JarDiscovererCache.load();
        }
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private static void applyMixinFix() {
        OPTIFINE = VintageFixCore.classExists("ofdev.launchwrapper.OptifineDevTweakerWrapper") || VintageFixCore.classExists("optifine.OptiFineForgeTweaker");
        try {
            Field groupMembersField = InjectorGroupInfo.class.getDeclaredField("members");
            groupMembersField.setAccessible(true);
            Field noGroupField = InjectorGroupInfo.Map.class.getDeclaredField("NO_GROUP");
            noGroupField.setAccessible(true);
            InjectorGroupInfo noGroup = (InjectorGroupInfo)noGroupField.get(null);
            groupMembersField.set(noGroup, new DummyList());
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
    }

    public List<String> getMixinConfigs() {
        if (!mixinFixApplied) {
            VintageFixCore.applyMixinFix();
            mixinFixApplied = true;
        }
        return ImmutableList.of((Object)"mixins.vintagefix.json");
    }

    static {
        mixinFixApplied = false;
    }
}

