/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.gui;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.latmod.yabba.net.MessageSelectModel;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;

public class GuiSelectModel
extends GuiBase {
    private final List<ButtonModel> buttons;

    public GuiSelectModel() {
        int cols = 4;
        int rows = 3;
        this.setSize(19 + cols * 38, 19 + rows * 38);
        this.buttons = new ArrayList<ButtonModel>();
        for (int i = 0; i < cols * rows; ++i) {
            this.buttons.add(new ButtonModel((Panel)this, i));
        }
    }

    public void addWidgets() {
        this.addAll(this.buttons);
    }

    private class ButtonModel
    extends Button {
        private final EnumBarrelModel model;

        public ButtonModel(Panel panel, int i) {
            super(panel);
            this.setPosAndSize(8 + i % 4 * 39, 8 + i / 4 * 39, 38, 38);
            EnumBarrelModel enumBarrelModel = this.model = i >= EnumBarrelModel.NAME_MAP.size() ? null : (EnumBarrelModel)((Object)EnumBarrelModel.NAME_MAP.get(i));
            if (this.model != null) {
                this.setTitle(I18n.func_135052_a((String)this.model.getTranslationKey(), (Object[])new Object[0]));
            }
        }

        public void onClicked(MouseButton button) {
            if (this.model != null) {
                GuiHelper.playClickSound();
                new MessageSelectModel(this.model).sendToServer();
                this.getGui().closeGui();
            }
        }

        public WidgetType getWidgetType() {
            return this.model == null ? WidgetType.DISABLED : super.getWidgetType();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            this.drawBackground(theme, x, y, w, h);
            this.drawIcon(theme, x, y, w, h);
        }

        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            if (this.model != null) {
                this.model.icon.draw(x + 3, y + 3, 32, 32);
            }
        }
    }
}

