/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.breeding;

import java.util.List;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.common.entities.EntityChocobo;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.chococraft.common.init.ModBlocks;
import net.chococraft.common.tileentities.TileEntityChocoboEgg;
import net.chococraft.utils.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityChocoboAIMate
extends EntityAIBase {
    private static final Vec3i[] LAY_EGG_CHECK_OFFSETS = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(1, 0, 0), new Vec3i(1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(1, 1, 0), new Vec3i(1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(-1, 1, 1)};
    private final EntityChocobo chocobo;
    private final World world;
    private final double moveSpeed;
    private EntityChocobo targetMate;
    private int spawnBabyDelay;

    public EntityChocoboAIMate(EntityChocobo chocobo, double moveSpeed) {
        this.chocobo = chocobo;
        this.world = chocobo.field_70170_p;
        this.moveSpeed = moveSpeed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.chocobo.func_70880_s() && (this.targetMate = this.getNearbyMate()) != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.chocobo.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.chocobo.func_70646_bf());
        this.chocobo.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.chocobo.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.spawnEgg();
        }
    }

    @Nullable
    private EntityChocobo getNearbyMate() {
        List list = this.world.func_72872_a(EntityChocobo.class, this.chocobo.func_174813_aQ().func_186662_g(8.0));
        double dist = Double.MAX_VALUE;
        EntityChocobo closestMate = null;
        for (EntityChocobo entry : list) {
            if (!this.chocobo.func_70878_b((EntityAnimal)entry) || !(this.chocobo.func_70068_e((Entity)entry) < dist)) continue;
            closestMate = entry;
            dist = this.chocobo.func_70068_e((Entity)entry);
        }
        return closestMate;
    }

    private void spawnEgg() {
        if (this.chocobo.isMale()) {
            return;
        }
        this.chocobo.func_70873_a(6000);
        this.targetMate.func_70873_a(6000);
        this.chocobo.func_70875_t();
        this.targetMate.func_70875_t();
        BlockPos pos = this.chocobo.func_180425_c();
        for (Vec3i offset : LAY_EGG_CHECK_OFFSETS) {
            BlockPos offsetPos = pos.func_177971_a(offset);
            IBlockState state = this.world.func_180495_p(offsetPos);
            if (!state.func_185904_a().func_76222_j() || state.func_185904_a().func_76224_d() || !ModBlocks.chocoboEgg.func_176196_c(this.world, offsetPos)) continue;
            if (!this.world.func_175656_a(offsetPos, ModBlocks.chocoboEgg.func_176223_P())) {
                Chococraft.log.error("Unable to place egg @ {}, setBlockState() returned false!", (Object)offsetPos);
                return;
            }
            TileEntityChocoboEgg eggTile = WorldUtils.getTileEntitySafe((IBlockAccess)this.world, offsetPos, TileEntityChocoboEgg.class);
            if (eggTile == null) {
                Chococraft.log.error("Unable to place egg @ {}, no tile entity was found at the given position!", (Object)offsetPos);
                return;
            }
            eggTile.setBreedInfo(new ChocoboBreedInfo(new ChocoboStatSnapshot(this.chocobo), new ChocoboStatSnapshot(this.targetMate)));
            return;
        }
    }
}

