/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities;

import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.breeding.EntityChocoboAIMate;
import net.chococraft.common.entities.properties.ChocoboAttributes;
import net.chococraft.common.entities.properties.ChocoboColor;
import net.chococraft.common.entities.properties.EntityDataSerializers;
import net.chococraft.common.entities.properties.MovementType;
import net.chococraft.common.entities.properties.SaddleType;
import net.chococraft.common.init.ModItems;
import net.chococraft.common.init.ModSounds;
import net.chococraft.common.inventory.ContainerSaddleBag;
import net.chococraft.common.inventory.SaddleItemStackHandler;
import net.chococraft.common.network.PacketManager;
import net.chococraft.common.network.packets.PacketOpenChocoboGui;
import net.chococraft.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class EntityChocobo
extends EntityTameable {
    private static final ResourceLocation CHOCOBO_LOOTABLE = new ResourceLocation("chococraft", "entities/chocobo");
    public static final String NBTKEY_CHOCOBO_COLOR = "Color";
    public static final String NBTKEY_CHOCOBO_IS_MALE = "Male";
    public static final String NBTKEY_MOVEMENTTYPE = "MovementType";
    public static final String NBTKEY_SADDLE_ITEM = "Saddle";
    public static final String NBTKEY_INVENTORY = "Inventory";
    public static final String NBTKEY_NEST_POSITION = "NestPos";
    public static final String NBTKEY_CHOCOBO_GENERATION = "Generation";
    public static final String NBTKEY_CHOCOBO_STAMINA = "Stamina";
    public static final String NBTKEY_CHOCOBO_CAN_FLY = "CanFly";
    public static final String NBTKEY_CHOCOBO_CAN_GLIDE = "CanGlide";
    public static final String NBTKEY_CHOCOBO_CAN_SPRINT = "CanSprint";
    public static final String NBTKEY_CHOCOBO_CAN_DIVE = "CanDive";
    private static final byte CAN_SPRINT_BIT = 1;
    private static final byte CAN_DIVE_BIT = 2;
    private static final byte CAN_GLIDE_BIT = 4;
    private static final byte CAN_FLY_BIT = 8;
    private static final DataParameter<ChocoboColor> PARAM_COLOR = EntityDataManager.func_187226_a(EntityChocobo.class, EntityDataSerializers.CHOCOBO_COLOR);
    private static final DataParameter<Boolean> PARAM_IS_MALE = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<MovementType> PARAM_MOVEMENT_TYPE = EntityDataManager.func_187226_a(EntityChocobo.class, EntityDataSerializers.MOVEMENT_TYPE);
    private static final DataParameter<ItemStack> PARAM_SADDLE_ITEM = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> PARAM_GENERATION = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PARAM_STAMINA = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> PARAM_ABILITY_MASK = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final UUID CHOCOBO_SPRINTING_BOOST_ID = UUID.fromString("03ba3167-393e-4362-92b8-909841047640");
    private static final AttributeModifier CHOCOBO_SPRINTING_SPEED_BOOST = new AttributeModifier(CHOCOBO_SPRINTING_BOOST_ID, "Chocobo sprinting speed boost", 1.0, 1).func_111168_a(false);
    public final ItemStackHandler chocoboInventory = new ItemStackHandler();
    public final SaddleItemStackHandler saddleItemStackHandler = new SaddleItemStackHandler(){

        @Override
        protected void onStackChanged() {
            EntityChocobo.this.setSaddleType(this.itemStack);
        }
    };
    public float wingRotation;
    public float destPos;
    private boolean isChocoboJumping;
    private float wingRotDelta;
    private BlockPos nestPos;
    private final EntityAIFollowOwner follow = new EntityAIFollowOwner((EntityTameable)this, 2.0, 3.0f, 10.0f);
    public float followingmrhuman = 2.0f;
    public int TimeSinceFeatherChance = 0;

    public EntityChocobo(World world) {
        super(world);
        this.func_70105_a(1.2f, 2.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityChocoboAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, Collections.singleton(ModItems.gysahlGreen)));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(ChocoboAttributes.MAX_STAMINA).func_111128_a((double)ChocoConfig.chocobo.defaultStamina);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)((float)ChocoConfig.chocobo.defaultSpeed / 100.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ChocoConfig.chocobo.defaultHealth);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARAM_COLOR, (Object)ChocoboColor.YELLOW);
        this.field_70180_af.func_187214_a(PARAM_IS_MALE, (Object)false);
        this.field_70180_af.func_187214_a(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        this.field_70180_af.func_187214_a(PARAM_SADDLE_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(PARAM_STAMINA, (Object)Float.valueOf(ChocoConfig.chocobo.defaultStamina));
        this.field_70180_af.func_187214_a(PARAM_GENERATION, (Object)0);
        this.field_70180_af.func_187214_a(PARAM_ABILITY_MASK, (Object)0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return CHOCOBO_LOOTABLE;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setMale(this.field_70170_p.field_73012_v.nextBoolean());
        if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).contains(this.field_70170_p.func_180494_b(new BlockPos((Entity)this).func_177977_b()))) {
            this.setChocoboColor(ChocoboColor.FLAME);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_82171_bF() {
        return this.func_70909_n();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setChocoboColor(ChocoboColor.values()[nbt.func_74771_c(NBTKEY_CHOCOBO_COLOR)]);
        this.setMale(nbt.func_74767_n(NBTKEY_CHOCOBO_IS_MALE));
        this.setMovementType(MovementType.values()[nbt.func_74771_c(NBTKEY_MOVEMENTTYPE)]);
        this.saddleItemStackHandler.deserializeNBT(nbt.func_74775_l(NBTKEY_SADDLE_ITEM));
        if (this.getSaddleType() != SaddleType.NONE) {
            this.chocoboInventory.deserializeNBT(nbt.func_74775_l(NBTKEY_INVENTORY));
        }
        if (nbt.func_74764_b(NBTKEY_NEST_POSITION)) {
            this.nestPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l(NBTKEY_NEST_POSITION));
        }
        this.setGeneration(nbt.func_74762_e(NBTKEY_CHOCOBO_GENERATION));
        this.setStamina(nbt.func_74760_g(NBTKEY_CHOCOBO_STAMINA));
        this.setCanFly(nbt.func_74767_n(NBTKEY_CHOCOBO_CAN_FLY));
        this.setCanGlide(nbt.func_74767_n(NBTKEY_CHOCOBO_CAN_GLIDE));
        this.setCanSprint(nbt.func_74767_n(NBTKEY_CHOCOBO_CAN_SPRINT));
        this.setCanDive(nbt.func_74767_n(NBTKEY_CHOCOBO_CAN_DIVE));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBTKEY_CHOCOBO_COLOR, (byte)this.getChocoboColor().ordinal());
        nbt.func_74757_a(NBTKEY_CHOCOBO_IS_MALE, this.isMale());
        nbt.func_74774_a(NBTKEY_MOVEMENTTYPE, (byte)this.getMovementType().ordinal());
        nbt.func_74782_a(NBTKEY_SADDLE_ITEM, (NBTBase)this.saddleItemStackHandler.serializeNBT());
        if (this.getSaddleType() != SaddleType.NONE) {
            nbt.func_74782_a(NBTKEY_INVENTORY, (NBTBase)this.chocoboInventory.serializeNBT());
        }
        if (this.nestPos != null) {
            nbt.func_74782_a(NBTKEY_NEST_POSITION, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.nestPos));
        }
        nbt.func_74768_a(NBTKEY_CHOCOBO_GENERATION, this.getGeneration());
        nbt.func_74776_a(NBTKEY_CHOCOBO_STAMINA, this.getStamina());
        nbt.func_74757_a(NBTKEY_CHOCOBO_CAN_FLY, this.canFly());
        nbt.func_74757_a(NBTKEY_CHOCOBO_CAN_GLIDE, this.canGlide());
        nbt.func_74757_a(NBTKEY_CHOCOBO_CAN_SPRINT, this.canSprint());
        nbt.func_74757_a(NBTKEY_CHOCOBO_CAN_DIVE, this.canDive());
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.field_70180_af.func_187225_a(PARAM_COLOR));
    }

    public void setChocoboColor(ChocoboColor color) {
        this.field_70180_af.func_187227_b(PARAM_COLOR, (Object)color);
        this.field_70178_ae = color == ChocoboColor.FLAME;
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.field_70180_af.func_187227_b(PARAM_IS_MALE, (Object)isMale);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.field_70180_af.func_187225_a(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.field_70180_af.func_187227_b(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public boolean isSaddled() {
        return this.getSaddleType().isRidingSaddle();
    }

    public SaddleType getSaddleType() {
        return ModItems.chocoboSaddle.getSaddleType((ItemStack)this.field_70180_af.func_187225_a(PARAM_SADDLE_ITEM));
    }

    private void setSaddleType(ItemStack saddleStack) {
        SaddleType newType = ModItems.chocoboSaddle.getSaddleType(saddleStack);
        SaddleType oldType = this.getSaddleType();
        if (oldType != newType) {
            this.field_70180_af.func_187227_b(PARAM_SADDLE_ITEM, (Object)saddleStack.func_77946_l());
            this.reconfigureInventory(oldType, newType);
        }
    }

    @Nullable
    public BlockPos getNestPosition() {
        return this.nestPos;
    }

    public void setNestPosition(@Nullable BlockPos nestPos) {
        this.nestPos = nestPos;
    }

    public float getStamina() {
        return ((Float)this.field_70180_af.func_187225_a(PARAM_STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        this.field_70180_af.func_187227_b(PARAM_STAMINA, (Object)Float.valueOf(value));
    }

    public float getStaminaPercentage() {
        return (float)((double)this.getStamina() / this.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111126_e());
    }

    public int getGeneration() {
        return (Integer)this.field_70180_af.func_187225_a(PARAM_GENERATION);
    }

    public void setGeneration(int value) {
        this.field_70180_af.func_187227_b(PARAM_GENERATION, (Object)value);
    }

    private boolean useStamina(float value) {
        if (value == 0.0f) {
            return true;
        }
        float curStamina = ((Float)this.field_70180_af.func_187225_a(PARAM_STAMINA)).floatValue();
        if (curStamina < value) {
            return false;
        }
        float maxStamina = (float)this.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111126_e();
        float newStamina = MathHelper.func_76131_a((float)(curStamina - value), (float)0.0f, (float)maxStamina);
        this.field_70180_af.func_187227_b(PARAM_STAMINA, (Object)Float.valueOf(newStamina));
        return true;
    }

    public boolean canFly() {
        return ((Byte)this.field_70180_af.func_187225_a(PARAM_ABILITY_MASK) & 8) > 0;
    }

    public void setCanFly(boolean state) {
        this.setAbilityMaskBit(8, state);
    }

    public boolean canGlide() {
        return ((Byte)this.field_70180_af.func_187225_a(PARAM_ABILITY_MASK) & 4) > 0;
    }

    public void setCanGlide(boolean state) {
        this.setAbilityMaskBit(4, state);
    }

    public boolean canSprint() {
        return ((Byte)this.field_70180_af.func_187225_a(PARAM_ABILITY_MASK) & 1) > 0;
    }

    public void setCanSprint(boolean state) {
        this.setAbilityMaskBit(1, state);
    }

    public boolean canDive() {
        return ((Byte)this.field_70180_af.func_187225_a(PARAM_ABILITY_MASK) & 2) > 0;
    }

    public void setCanDive(boolean state) {
        this.setAbilityMaskBit(2, state);
    }

    private void setAbilityMaskBit(int bit, boolean state) {
        byte value = (Byte)this.field_70180_af.func_187225_a(PARAM_ABILITY_MASK);
        this.field_70180_af.func_187227_b(PARAM_ABILITY_MASK, (Object)((byte)(state ? value | bit : value & ~bit)));
    }

    public double func_70042_X() {
        return 1.65;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityChocobo) {
            this.field_70171_ac = false;
        } else if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer rider = (EntityPlayer)this.func_184179_bs();
            this.field_70126_B = rider.field_70177_z;
            this.field_70127_C = rider.field_70125_A;
            this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = rider.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70177_z;
            this.field_70761_aq = this.field_70177_z;
            strafe = rider.field_70702_br * 0.5f;
            forward = rider.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.field_70122_E) {
                this.isChocoboJumping = false;
            }
            if ((this.canGlide() || this.canFly()) && !rider.func_70090_H()) {
                this.field_70747_aH = 0.07f;
            } else if (rider.func_70090_H() || !this.canGlide() && !this.canFly()) {
                this.field_70747_aH = 0.05f;
            }
            if (this.func_184186_bw()) {
                if (rider.field_70703_bu) {
                    if (rider.func_70051_ag() && this.canFly() && !rider.func_70090_H() && this.useStamina(ChocoConfig.chocobo.flyStaminaCost)) {
                        this.field_70181_x += this.field_70122_E ? 0.5 : (double)0.1f;
                        if (this.field_70181_x > 0.5) {
                            this.field_70181_x = 0.5;
                        }
                        this.func_70031_b(false);
                    } else if (!this.isChocoboJumping && this.field_70122_E && this.useStamina(ChocoConfig.chocobo.jumpStaminaCost)) {
                        this.field_70181_x = 0.6f;
                        this.isChocoboJumping = true;
                    }
                }
                if (rider.func_70090_H()) {
                    int distance;
                    if (this.canDive()) {
                        if (rider.func_70093_af()) {
                            this.field_70181_x -= (double)0.05f;
                            if (this.field_70181_x < (double)-0.7f) {
                                this.field_70181_x = -0.7f;
                            }
                        }
                        if (rider.field_70703_bu) {
                            this.field_70181_x = 0.5;
                        }
                        this.field_70171_ac = false;
                        this.func_70031_b(false);
                    } else if (rider.field_70703_bu) {
                        this.field_70181_x = 0.5;
                    } else if (this.field_70181_x < 0.0 && (distance = WorldUtils.getDistanceToSurface(this.func_180425_c(), this.func_130014_f_())) > 0) {
                        this.field_70181_x = (double)0.01f + Math.min((double)(0.05f * (float)distance), 0.7);
                    }
                }
                if (!this.field_70122_E && !this.func_70090_H() && !rider.func_70093_af() && this.field_70181_x < 0.0 && this.canGlide() && this.useStamina(ChocoConfig.chocobo.glideStaminaCost)) {
                    this.field_70181_x *= (double)0.65f;
                }
                if (this.func_70051_ag() && !this.useStamina(ChocoConfig.chocobo.sprintStaminaCost) || this.func_70051_ag() && this.func_70090_H() && this.useStamina(ChocoConfig.chocobo.sprintStaminaCost) || this.func_70051_ag() && !this.canSprint() && this.useStamina(ChocoConfig.chocobo.sprintStaminaCost)) {
                    this.func_70031_b(false);
                }
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving && this.func_184179_bs() == passenger) {
            this.field_70761_aq = ((EntityLivingBase)passenger).field_70761_aq;
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable entity) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this || !(otherAnimal instanceof EntityChocobo)) {
            return false;
        }
        if (!this.func_70880_s() || !otherAnimal.func_70880_s()) {
            return false;
        }
        EntityChocobo otherChocobo = (EntityChocobo)otherAnimal;
        return otherChocobo.isMale() != this.isMale();
    }

    public void func_70031_b(boolean sprinting) {
        this.func_70052_a(3, sprinting);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance.func_111127_a(CHOCOBO_SPRINTING_BOOST_ID) != null) {
            iattributeinstance.func_111124_b(CHOCOBO_SPRINTING_SPEED_BOOST);
        }
        if (sprinting && this.canSprint()) {
            iattributeinstance.func_111121_a(CHOCOBO_SPRINTING_SPEED_BOOST);
        }
    }

    public void dropFeather() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.func_70631_g_()) {
            return;
        }
        this.func_70099_a(new ItemStack(ModItems.chocoboFeather, 1), 0.0f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.regenerateStamina();
        this.field_70138_W = 1.0f;
        this.field_70143_R = 0.0f;
        if (this.TimeSinceFeatherChance == 3000) {
            this.TimeSinceFeatherChance = 0;
            if ((double)((float)Math.random()) < 0.25) {
                this.dropFeather();
            }
        } else {
            ++this.TimeSinceFeatherChance;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.field_70173_aa % 60 == 0) {
                Entity controller;
                if (this.canDive()) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 0, true, false));
                    if (this.func_184207_aI() && (controller = this.func_184179_bs()) instanceof EntityPlayer) {
                        ((EntityPlayer)controller).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 0, true, false));
                    }
                }
                if (this.getChocoboColor() == ChocoboColor.FLAME) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 100, 0, true, false));
                    if (this.func_184207_aI() && (controller = this.func_184179_bs()) instanceof EntityPlayer) {
                        ((EntityPlayer)controller).func_70690_d(new PotionEffect(MobEffects.field_76426_n, 100, 0, true, false));
                    }
                }
            }
        } else {
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.field_70122_E) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            this.wingRotation += this.wingRotDelta * 2.0f;
            if (this.field_70122_E) {
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_184619_aG = 0.0f;
                this.field_70721_aZ = 0.0f;
                this.field_184618_aE = 0.0f;
            }
        }
    }

    private void regenerateStamina() {
        if (!(this.field_70122_E || this.func_70090_H() || this.func_180799_ab() || this.func_70051_ag())) {
            return;
        }
        float regen = ChocoConfig.chocobo.staminaRegenRate;
        if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
            regen = (float)((double)regen * 0.85);
        }
        this.useStamina(-regen);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Optional<ChocoboColor> color;
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (heldItemStack.func_77973_b() == ModItems.chocopedia) {
            Chococraft.proxy.openChocoboInfoGui(this, player);
            return true;
        }
        if (this.func_70909_n() && player.func_70093_af() && !this.func_70631_g_()) {
            if (player instanceof EntityPlayerMP) {
                this.displayChocoboInventory((EntityPlayerMP)player);
            }
            return true;
        }
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        if (this.isSaddled() && heldItemStack.func_190926_b() && !player.func_70093_af() && !this.func_70631_g_()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        if (!this.func_70909_n() && heldItemStack.func_77973_b() == ModItems.gysahlGreen) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            if ((double)((float)Math.random()) < ChocoConfig.chocobo.tameChance) {
                this.func_184754_b(player.func_110124_au());
                this.func_70903_f(true);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.tame_success", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.tame_fail", new Object[0]), true);
            }
            return true;
        }
        if (this.func_70909_n() && heldItemStack.func_77973_b() == ModItems.gysahlGreen) {
            if (this.func_110143_aJ() != this.func_110138_aP()) {
                this.func_175505_a(player, player.field_71071_by.func_70448_g());
                this.func_70691_i(5.0f);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.heal_fail", new Object[0]), true);
            }
        }
        if (this.func_70909_n() && heldItemStack.func_77973_b() == ModItems.chocoboWhistle && !this.func_70631_g_()) {
            if (this.func_152114_e((EntityLivingBase)player)) {
                if (this.followingmrhuman == 3.0f) {
                    this.func_184185_a(ModSounds.WHISTLE_SOUND_FOLLOW, 1.0f, 1.0f);
                    this.func_94061_f(false);
                    this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.follow);
                    this.followingmrhuman = 1.0f;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.chocobo_followcmd", new Object[0]), true);
                } else if (this.followingmrhuman == 1.0f) {
                    this.func_184185_a(ModSounds.WHISTLE_SOUND_WANDER, 1.0f, 1.0f);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.follow);
                    this.followingmrhuman = 2.0f;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.chocobo_wandercmd", new Object[0]), true);
                } else if (this.followingmrhuman == 2.0f) {
                    this.func_184185_a(ModSounds.WHISTLE_SOUND_STAY, 1.0f, 1.0f);
                    this.func_94061_f(true);
                    this.followingmrhuman = 3.0f;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.chocobo_staycmd", new Object[0]), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.not_owner", new Object[0]), true);
            }
            return true;
        }
        if (this.func_70909_n() && !this.func_70880_s() && heldItemStack.func_77973_b() == ModItems.lovelyGysahlGreen && !this.func_70631_g_()) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.func_146082_f(player);
            return true;
        }
        if (heldItemStack.func_77973_b() == ModItems.chocoboSaddle && this.func_70909_n() && !this.isSaddled() && !this.func_70631_g_()) {
            this.saddleItemStackHandler.setStackInSlot(0, heldItemStack.func_77946_l().func_77979_a(1));
            this.setSaddleType(heldItemStack);
            this.func_175505_a(player, heldItemStack);
            return true;
        }
        if (this.func_70909_n() && !heldItemStack.func_190926_b() && (color = ChocoboColor.getColorForItemstack(heldItemStack)).isPresent()) {
            if (this.func_152114_e((EntityLivingBase)player)) {
                this.func_175505_a(player, heldItemStack);
                this.setChocoboColor(color.get());
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.not_owner", new Object[0]), true);
            }
            return true;
        }
        if (this.func_70909_n() && heldItemStack.func_77973_b() == Items.field_151057_cb && !this.func_152114_e((EntityLivingBase)player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.not_owner", new Object[0]), true);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void displayChocoboInventory(EntityPlayerMP player) {
        player.func_71117_bO();
        player.field_71070_bA = new ContainerSaddleBag(this, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
        PacketManager.INSTANCE.sendTo((IMessage)new PacketOpenChocoboGui(this, player.field_71139_cq), player);
    }

    private void reconfigureInventory(SaddleType oldType, SaddleType newType) {
        if (!this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < this.chocoboInventory.getSlots(); ++i) {
                if (this.field_70128_L) continue;
                ItemStack stack = this.chocoboInventory.extractItem(i, Integer.MAX_VALUE, false);
                InventoryHelper.func_180173_a((World)this.func_130014_f_(), (double)this.field_70165_t, (double)(this.field_70163_u + 0.5), (double)this.field_70161_v, (ItemStack)stack);
            }
        }
        this.chocoboInventory.setSize(newType.getInventorySize());
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(player.field_71070_bA instanceof ContainerSaddleBag)) continue;
            ((ContainerSaddleBag)player.field_71070_bA).refreshSlots(this, player);
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        if (this.chocoboInventory != null && this.isSaddled()) {
            for (int i = 0; i < this.chocoboInventory.getSlots(); ++i) {
                if (this.chocoboInventory.getStackInSlot(i).func_190926_b()) continue;
                this.func_70099_a(this.chocoboInventory.getStackInSlot(i), 0.0f);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.AMBIENT_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.AMBIENT_SOUND;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.AMBIENT_SOUND;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return 24 * (int)(Math.random() * 100.0);
    }

    public boolean func_70601_bi() {
        if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).contains(this.field_70170_p.func_180494_b(new BlockPos((Entity)this).func_177977_b()))) {
            return true;
        }
        return super.func_70601_bi();
    }
}

