/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="chococraft")
@Config(modid="chococraft")
public class ChocoConfig {
    @Config.Comment(value={"World generation related configuration"})
    @Config.Name(value="world")
    public static WorldConfig world = new WorldConfig();
    @Config.Name(value="chocobo")
    public static ChocoboConfig chocobo = new ChocoboConfig();
    @Config.Name(value="breeding")
    public static BreedingConfig breeding = new BreedingConfig();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("chococraft")) {
            if (ChocoConfig.world.chocoboPackSizeMin > ChocoConfig.world.chocoboPackSizeMax) {
                int t = ChocoConfig.world.chocoboPackSizeMax;
                ChocoConfig.world.chocoboPackSizeMax = ChocoConfig.world.chocoboPackSizeMin;
                ChocoConfig.world.chocoboPackSizeMin = t;
            }
            ConfigManager.sync((String)"chococraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class BreedingConfig {
        @Config.Comment(value={"This number controls the max stats a chocobo can have."})
        @Config.RangeInt(min=0)
        public int maxHealth = 50;
        @Config.RangeInt(min=0)
        public int maxSpeed = 40;
        @Config.RangeInt(min=0)
        public float maxStamina = 25.0f;
        @Config.Comment(value={"This multiplier controls the max stat gain, for example 0.05 would result in a max gain of 5% so 20 to 21."})
        @Config.RangeDouble(min=0.0)
        public float posgainHealth = 0.1f;
        @Config.RangeDouble(min=0.0)
        public float posgainSpeed = 0.1f;
        @Config.RangeDouble(min=0.0)
        public float posgainStamina = 0.1f;
        @Config.Comment(value={"This multiplier controls the max stat loss, for example 0.95 would result in a max loss of 5% so 20 to 19."})
        @Config.RangeDouble(min=0.0)
        public float poslossHealth = 0.95f;
        @Config.RangeDouble(min=0.0)
        public float poslossSpeed = 0.95f;
        @Config.RangeDouble(min=0.0)
        public float poslossStamina = 0.95f;
        @Config.Comment(value={"This number controls the amount of ticks / time till an egg hatches. This value isnt super accurate."})
        @Config.RangeInt(min=0)
        public int eggHatchTimeTicks = 10000;
    }

    public static class ChocoboConfig {
        @Config.Comment(value={"This decides whether or not saddles are cosmetic only."})
        public boolean saddlesCosmeticOnly = false;
        @Config.Comment(value={"This multiplier controls the tame chance per gysahl used, so .15 results in 15% chance to tame."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double tameChance = 0.15;
        @Config.RangeDouble(min=0.0)
        public float sprintStaminaCost = 0.06f;
        @Config.RangeDouble(min=0.0)
        public float glideStaminaCost = 0.005f;
        @Config.Comment(value={"This float controls the amount of stamina consumed per tick by each ability."})
        @Config.RangeDouble(min=0.0)
        public float flyStaminaCost = 0.08f;
        @Config.RangeDouble(min=0.0)
        public float jumpStaminaCost = 0.0f;
        @Config.Comment(value={"This float controls the amount of stamina recharged per tick."})
        @Config.RangeDouble(min=0.0)
        public float staminaRegenRate = 0.025f;
        @Config.RangeInt(min=0)
        public int defaultStamina = 10;
        @Config.RangeInt(min=0)
        public int defaultSpeed = 20;
        @Config.Comment(value={"This number controls the default stats a chocobo spawns with."})
        @Config.RangeInt(min=0)
        public int defaultHealth = 20;
        @Config.RangeInt(min=1)
        public int ExpCostSprint = 1500;
        @Config.RangeInt(min=1)
        public int ExpCostGlide = 1500;
        @Config.Comment(value={"This number controls the amount of exp required to unlock abilities."})
        @Config.RangeInt(min=1)
        public int ExpCostDive = 1000;
        @Config.RangeInt(min=1)
        public int ExpCostFly = 2000;
    }

    public static class WorldConfig {
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Controls the weight compared to other world gen"})
        @Config.RequiresMcRestart
        public int gysahlGreenSpawnWeight = 3;
        @Config.RangeInt(min=0)
        public int gysahlGreenPatchSize = 64;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double gysahlGreenSpawnChance = 0.1;
        public boolean gysahlGreensSpawnOnlyInOverworld = true;
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int chocoboSpawnWeight = 10;
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int chocoboPackSizeMin = 1;
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int chocoboPackSizeMax = 3;
        @Config.RequiresMcRestart
        public int retrogenId = 1;
        public boolean addAbilityFruitsToDungeonLoot = true;
        @Config.Comment(value={"This number controls the weight ability fruit has compared to other items in a loot table."})
        @Config.RangeInt(min=0)
        public int abilityFruitDungeonLootWeight = 1;
    }
}

