/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.entities.ai;

import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import micdoodle8.mods.galacticraft.planets.venus.entities.ai.WalkNodeProcessorCeiling;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PathNavigateCeiling
extends PathNavigate {
    protected WalkNodeProcessorCeiling nodeProcessor;

    public PathNavigateCeiling(EntityJuicer entity, World worldIn) {
        super((EntityLiving)entity, worldIn);
    }

    protected PathFinder func_179679_a() {
        this.nodeProcessor = new WalkNodeProcessorCeiling();
        return new PathFinder((NodeProcessor)this.nodeProcessor);
    }

    protected boolean func_75485_k() {
        return this.field_75515_a.field_70122_E || this.field_75515_a.func_184218_aH() && this.field_75515_a instanceof EntityZombie && this.field_75515_a.func_184187_bx() instanceof EntityChicken;
    }

    protected Vec3d func_75502_i() {
        return new Vec3d(this.field_75515_a.field_70165_t, (double)this.getPathablePosY(), this.field_75515_a.field_70161_v);
    }

    private int getPathablePosY() {
        return (int)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5);
    }

    protected boolean func_75493_a(Vec3d current, Vec3d target, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.func_76128_c((double)current.field_72450_a);
        int j = MathHelper.func_76128_c((double)current.field_72449_c);
        double d0 = target.field_72450_a - current.field_72450_a;
        double d1 = target.field_72449_c - current.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(i, (int)current.field_72448_b, j, sizeX += 2, sizeY, sizeZ += 2, current, d0 *= d3, d1 *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)i - current.field_72450_a;
        double d7 = (double)j - current.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int k = d0 < 0.0 ? -1 : 1;
        int l = d1 < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)target.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)target.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, (int)current.field_72448_b, j, sizeX, sizeY, sizeZ, current, d0, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d currentPos, double distanceX, double distanceZ) {
        int i = x - sizeX / 2;
        int j = z - sizeZ / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, currentPos, distanceX, distanceZ)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - currentPos.field_72450_a;
                double d1 = (double)l + 0.5 - currentPos.field_72449_c;
                if (!(d0 * distanceX + d1 * distanceZ >= 0.0)) continue;
                IBlockState state = this.field_75513_b.func_180495_p(new BlockPos(k, y + 1, l));
                Material material = state.func_185904_a();
                if (material == Material.field_151579_a) {
                    return false;
                }
                if (material == Material.field_151586_h && !this.field_75515_a.func_70090_H()) {
                    return false;
                }
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int minX, int minY, int minZ, int sizeX, int sizeY, int sizeZ, Vec3d currentPos, double distanceX, double distanceZ) {
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(minX + sizeX - 1, minY + sizeY - 1, minZ + sizeZ - 1))) {
            Block block;
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - currentPos.field_72450_a;
            if (!(d0 * distanceX + (d1 = (double)blockpos.func_177952_p() + 0.5 - currentPos.field_72449_c) * distanceZ >= 0.0) || (block = this.field_75513_b.func_180495_p(blockpos).func_177230_c()).func_176205_b((IBlockAccess)this.field_75513_b, blockpos)) continue;
            return false;
        }
        return true;
    }
}

