/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.datafix.types;

import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.datafix.base.AbstractFixableData;
import micdoodle8.mods.galacticraft.core.datafix.base.GCFix;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TileFixer
extends AbstractFixableData {
    private final Map<String, String> tileEntityNames = new HashMap<String, String>();
    private final String modid;

    protected TileFixer(String modId) {
        super(GCFix.TILE_ENTITIES);
        this.modid = modId;
    }

    protected void putFixEntry(String from) {
        this.putFixEntry(from, from.replaceAll(" ", "_").toLowerCase());
    }

    protected void putFixEntry(String from, String to) {
        String toLocation = this.modid + ":" + to;
        this.tileEntityNames.put("minecraft:" + from.toLowerCase(), toLocation);
    }

    public NBTTagCompound func_188217_a(NBTTagCompound nbt) {
        String loc = nbt.func_74779_i("id");
        if (this.tileEntityNames.containsKey(loc)) {
            String id = this.tileEntityNames.get(loc);
            nbt.func_74778_a("id", this.tileEntityNames.get(loc));
            if (ConfigManagerCore.enableDebug) {
                BlockPos p = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
                GalacticraftCore.logger.info("DataFixer @ {} -> {}", p.toString(), p.toString(), id);
            }
        }
        return nbt;
    }
}

