/*
 * Decompiled with CFR 0.152.
 */
package therealfarfetchd.quacklib.common.api.world;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;
import therealfarfetchd.quacklib.QuackLib;
import therealfarfetchd.quacklib.common.api.autoconf.DefaultFeatures;
import therealfarfetchd.quacklib.common.api.autoconf.FeatureManager;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016Jl\u0010\u0017\u001a\u00020\u000f2d\u0010\u0018\u001a`\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u0005j\u0002`\u0010J&\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fRr\u0010\u0003\u001af\u0012b\u0012`\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u0005j\u0002`\u00100\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltherealfarfetchd/quacklib/common/api/world/QWorldGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "generators", "", "Lkotlin/Function4;", "Lnet/minecraft/world/World;", "Lkotlin/ParameterName;", "name", "world", "Ljava/util/Random;", "rnd", "", "chunkX", "chunkZ", "", "Ltherealfarfetchd/quacklib/common/api/world/Generator;", "generate", "random", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "registerGenerator", "gen", "registerOreGenerator", "ore", "Lnet/minecraft/block/state/IBlockState;", "height", "Lkotlin/ranges/IntRange;", "veinSize", "veinsPerChunk", "QuackLib"})
public final class QWorldGenerator
implements IWorldGenerator {
    private static List<? extends Function4<? super World, ? super Random, ? super Integer, ? super Integer, Unit>> generators;
    public static final QWorldGenerator INSTANCE;

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        Iterable $receiver$iv = generators;
        for (Object element$iv : $receiver$iv) {
            Function4 it = (Function4)element$iv;
            it.invoke((Object)world, (Object)random, (Object)chunkX, (Object)chunkZ);
        }
    }

    public final void registerGenerator(@NotNull Function4<? super World, ? super Random, ? super Integer, ? super Integer, Unit> gen) {
        Intrinsics.checkParameterIsNotNull(gen, (String)"gen");
        if (!FeatureManager.INSTANCE.isRequired(DefaultFeatures.INSTANCE.getOreGeneration())) {
            QuackLib.INSTANCE.getLogger$QuackLib().warn("World generation is not enabled, not registering generator! Please enable it with the feature manager on startup.");
        } else {
            generators = CollectionsKt.plus((Collection)generators, gen);
        }
    }

    public final void registerOreGenerator(@NotNull IBlockState ore, @NotNull IntRange height, int veinSize, int veinsPerChunk) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        WorldGenMinable gen = new WorldGenMinable(ore, veinSize);
        this.registerGenerator((Function4<? super World, ? super Random, ? super Integer, ? super Integer, Unit>)((Function4)new Function4<World, Random, Integer, Integer, Unit>(veinsPerChunk, height, gen){
            final /* synthetic */ int $veinsPerChunk;
            final /* synthetic */ IntRange $height;
            final /* synthetic */ WorldGenMinable $gen;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull World world, @NotNull Random rnd, int chunkX, int chunkZ) {
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)rnd, (String)"rnd");
                int n = 0;
                int n2 = this.$veinsPerChunk;
                while (n < n2) {
                    void i;
                    int x = chunkX * 16 + rnd.nextInt(16);
                    int z = chunkZ * 16 + rnd.nextInt(16);
                    int y = rnd.nextInt(CollectionsKt.count((Iterable)((Iterable)this.$height))) + this.$height.getFirst();
                    BlockPos blockPos = new BlockPos(x, y, z);
                    this.$gen.func_180709_b(world, rnd, blockPos);
                    ++i;
                }
            }
            {
                this.$veinsPerChunk = n;
                this.$height = intRange;
                this.$gen = worldGenMinable;
                super(4);
            }
        }));
    }

    private QWorldGenerator() {
    }

    static {
        QWorldGenerator qWorldGenerator;
        INSTANCE = qWorldGenerator = new QWorldGenerator();
        generators = CollectionsKt.emptyList();
    }
}

