/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.proxy;

import betterwithmods.module.gameplay.Gameplay;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import zone.rong.loliasm.LoliASM;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.LoliReflector;
import zone.rong.loliasm.api.LoliStringPool;
import zone.rong.loliasm.api.datastructures.DummyMap;
import zone.rong.loliasm.api.datastructures.ResourceCache;
import zone.rong.loliasm.api.mixins.RegistrySimpleExtender;
import zone.rong.loliasm.client.LoliIncompatibilityHandler;
import zone.rong.loliasm.common.java.JavaFixes;
import zone.rong.loliasm.common.modfixes.betterwithmods.BWMBlastingOilOptimization;
import zone.rong.loliasm.common.modfixes.ebwizardry.ArcaneLocks;
import zone.rong.loliasm.config.LoliConfig;

public class CommonProxy {
    public void throwIncompatibility() {
        boolean texFix = Loader.isModLoaded((String)"texfix");
        boolean vanillaFix = Loader.isModLoaded((String)"vanillafix");
        if (texFix || vanillaFix) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("LoliASM has replaced and improved upon functionalities from the following mods.");
            messages.add("Therefore, these mods are now incompatible with LoliASM:");
            messages.add("");
            if (texFix) {
                messages.add(TextFormatting.BOLD + "TexFix");
            }
            if (vanillaFix) {
                messages.add(TextFormatting.BOLD + "VanillaFix");
            }
            LoliIncompatibilityHandler.loliHaetPizza(messages);
        }
    }

    public void construct(FMLConstructionEvent event) {
        if (LoliConfig.instance.cleanupLaunchClassLoaderEarly) {
            CommonProxy.cleanupLaunchClassLoader();
        }
        if (LoliConfig.instance.threadPriorityFix) {
            Thread.currentThread().setPriority(7);
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (LoliConfig.instance.skipCraftTweakerRecalculatingSearchTrees) {
            LoliReflector.getClass("crafttweaker.mc1120.CraftTweaker").ifPresent(c -> {
                try {
                    Field alreadyChangedThePlayer = c.getDeclaredField("alreadyChangedThePlayer");
                    alreadyChangedThePlayer.setAccessible(true);
                    alreadyChangedThePlayer.setBoolean(null, true);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            });
        }
        if (Loader.isModLoaded((String)"betterwithmods") && LoliConfig.instance.bwmBlastingOilOptimization && !Gameplay.disableBlastingOilEvents) {
            MinecraftForge.EVENT_BUS.register(BWMBlastingOilOptimization.class);
        }
        if (Loader.isModLoaded((String)"ebwizardry") && LoliConfig.instance.optimizeArcaneLockRendering) {
            LoliASM.customTileDataConsumer = ArcaneLocks.TRACK_ARCANE_TILES;
        }
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        LoliLogger.instance.info("Trimming simple registries");
        HttpUtil.field_180193_a.execute(() -> {
            LoliASM.simpleRegistryInstances.forEach(RegistrySimpleExtender::trim);
            LoliASM.simpleRegistryInstances = null;
        });
        if (LoliConfig.instance.cleanupLaunchClassLoaderEarly || LoliConfig.instance.cleanCachesOnGameLoad) {
            this.invalidateLaunchClassLoaderCaches();
        } else if (LoliConfig.instance.cleanupLaunchClassLoaderLate) {
            CommonProxy.cleanupLaunchClassLoader();
        }
        if (LoliStringPool.getSize() > 0) {
            MinecraftForge.EVENT_BUS.register(LoliStringPool.class);
            LoliLogger.instance.info("{} total strings processed. {} unique strings in LoliStringPool, {} strings deduplicated altogether during game load.", (Object)LoliStringPool.getDeduplicatedCount(), (Object)LoliStringPool.getSize(), (Object)(LoliStringPool.getDeduplicatedCount() - (long)LoliStringPool.getSize()));
        }
        if (LoliConfig.instance.filePermissionsCacheCanonicalization) {
            MinecraftForge.EVENT_BUS.register((Object)JavaFixes.INSTANCE);
        }
    }

    private void invalidateLaunchClassLoaderCaches() {
        try {
            LoliLogger.instance.info("Invalidating and Cleaning LaunchClassLoader caches");
            if (!LoliConfig.instance.noClassCache) {
                LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader).clear();
            }
            if (!LoliConfig.instance.noResourceCache) {
                LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader).clear();
                LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "negativeResourceCache").invoke(Launch.classLoader).clear();
            }
            LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "invalidClasses").invoke(Launch.classLoader).clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void cleanupLaunchClassLoader() {
        try {
            LoliLogger.instance.info("Cleaning up LaunchClassLoader");
            if (LoliConfig.instance.noClassCache) {
                LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader, DummyMap.of());
            } else if (LoliConfig.instance.weakClassCache) {
                Map oldClassCache = LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader);
                Cache newClassCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
                newClassCache.putAll(oldClassCache);
                LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader, newClassCache.asMap());
            }
            if (LoliConfig.instance.noResourceCache) {
                LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader, new ResourceCache());
                LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "negativeResourceCache").invokeExact(Launch.classLoader, DummyMap.asSet());
            } else if (LoliConfig.instance.weakResourceCache) {
                Map oldResourceCache = LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader);
                Cache newResourceCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
                newResourceCache.putAll(oldResourceCache);
                LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader, newResourceCache.asMap());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

