/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FontMeasure {
    private Font font;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private FontRenderContext frc;
    private AffineTransform affineTransform;
    private double boundsHeight;
    private double boundsAscent;
    private double boundsDescent;
    private int pixelBoundsHeight;
    private int pixelBoundsAscent;
    private int pixelBoundsDescent;
    private double height;
    private double ascent;
    private double descent;
    private double maxHeight;
    private double maxAscent;
    private double maxDescent;
    private double leading;
    private double maxWidth;
    private char maxWidthChar;
    private double maxWidthWithLsb;
    private char maxWidthWithLsbChar;
    private double maxCharHeight;
    private char maxCharHeightChar;
    private double minLSB;
    private char minLSBChar;
    private String testString;

    public FontMeasure(Font font, boolean antiAlias, boolean fractionalMetrics) {
        this(font, antiAlias, fractionalMetrics, null);
    }

    public FontMeasure(Font font, boolean antiAlias, boolean fractionalMetrics, String testChars) {
        this.font = font;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
        this.affineTransform = font.getTransform();
        this.frc = new FontRenderContext(null, this.antiAlias, this.fractionalMetrics);
        if (testChars == null) {
            String referenceChars = FontMeasure.getStdSizingRefChars();
            this.testString = this.getDisplayableChars(referenceChars);
        } else {
            this.testString = this.getDisplayableChars(testChars);
        }
        GlyphVector gv = font.createGlyphVector(this.frc, this.testString);
        Rectangle2D rectangle = gv.getVisualBounds();
        this.boundsHeight = rectangle.getHeight();
        this.boundsAscent = Math.abs(rectangle.getY());
        this.boundsDescent = this.boundsHeight - this.boundsAscent;
        Rectangle pixelRect = gv.getPixelBounds(null, 0.0f, 0.0f);
        this.pixelBoundsHeight = ModLib.round(pixelRect.getHeight());
        this.pixelBoundsAscent = ModLib.round(Math.abs(pixelRect.getY()));
        this.pixelBoundsDescent = this.pixelBoundsHeight - this.pixelBoundsAscent;
        this.maxWidth = this.getMaxWidth(this.testString);
        this.maxWidthWithLsb = this.getMaxWidthWithLsb(this.testString);
        this.maxCharHeightChar = this.getMaxHeightChar(this.testString);
        this.maxCharHeight = this.getCharBoundsHeight(this.maxCharHeightChar);
        this.minLSB = this.getMinLSB(this.testString);
        FontMetrics fontMetrics = this.getFontMetrics(font, antiAlias, fractionalMetrics);
        this.maxAscent = fontMetrics.getMaxAscent();
        this.maxDescent = fontMetrics.getMaxDescent();
        this.leading = fontMetrics.getLeading();
        this.maxHeight = this.maxAscent + this.maxDescent + this.leading;
        this.ascent = fontMetrics.getAscent();
        this.descent = fontMetrics.getDescent();
        this.height = this.ascent + this.descent + this.leading;
    }

    public GlyphVector getGlyphVector() {
        return this.font.createGlyphVector(this.frc, this.testString);
    }

    public float getLeadingProxy() {
        return 0.0f;
    }

    public float getHeightProxy() {
        return this.getBoundsHeight();
    }

    public float getAscentProxy() {
        return this.getBoundsAscent();
    }

    public float getDescentProxy() {
        return this.getBoundsDescent();
    }

    private float getLeading() {
        return (float)this.leading;
    }

    private float getBoundsHeight() {
        return (float)this.boundsHeight;
    }

    private float getBoundsAscent() {
        return (float)this.boundsAscent;
    }

    private float getBoundsDescent() {
        return (float)this.boundsDescent;
    }

    public int getPixelBoundsHeight() {
        return this.pixelBoundsHeight;
    }

    public int getPixelBoundsAscent() {
        return this.pixelBoundsAscent;
    }

    public int getPixelBoundsDescent() {
        return this.pixelBoundsDescent;
    }

    private float getHeight() {
        return (float)this.height;
    }

    private float getAscent() {
        return (float)this.ascent;
    }

    private float getDescent() {
        return (float)this.descent;
    }

    private float getMaxHeight() {
        return (float)this.maxHeight;
    }

    private float getMaxAscent() {
        return (float)this.maxAscent;
    }

    private float getMaxDescent() {
        return (float)this.maxDescent;
    }

    public float getMaxWidth() {
        return (float)this.maxWidth;
    }

    public char getMaxWidthChar() {
        return this.maxWidthChar;
    }

    public float getMaxWidthWithLsb() {
        return (float)this.maxWidthWithLsb;
    }

    public char getMaxWidthWithLsbChar() {
        return this.maxWidthWithLsbChar;
    }

    public float getMinLSB() {
        return (float)this.minLSB;
    }

    public char getMinLSBChar() {
        return this.minLSBChar;
    }

    public float getMaxCharHeight() {
        return (float)this.maxCharHeight;
    }

    public char getMaxCharHeightChar() {
        return this.maxCharHeightChar;
    }

    public float getFittedSize(int pixelSize, float startSize, float step) {
        float size = startSize;
        float targetAscent = (float)pixelSize * GlobalConfig.autosizingTgtAscent;
        while (true) {
            Font workFont = this.font.deriveFont(size + step);
            FontMeasure fm = new FontMeasure(workFont, this.antiAlias, this.fractionalMetrics);
            float maxHeight = fm.getBoundsHeight();
            float maxAscent = fm.getBoundsAscent();
            Logger.debug("boundsAscent=", Float.valueOf(maxAscent), ", boundsHeight=", Float.valueOf(maxHeight), ", maxWidth(", Character.valueOf(fm.maxWidthChar), ")=", Float.valueOf(fm.getMaxWidth()));
            if (size > 10.0f && maxHeight == 0.0f) {
                Logger.warn("Invalid font height.");
                size = 0.0f;
                break;
            }
            if (!(maxAscent < targetAscent)) break;
            size += step;
        }
        return size;
    }

    private double getCharBoundsWidth(char ch) {
        GlyphVector gv = this.font.createGlyphVector(this.frc, String.valueOf(ch));
        Rectangle2D rectangle = gv.getVisualBounds();
        return rectangle.getWidth();
    }

    private double getCharBoundsHeight(char ch) {
        GlyphVector gv = this.font.createGlyphVector(this.frc, String.valueOf(ch));
        Rectangle2D rectangle = gv.getVisualBounds();
        return rectangle.getHeight();
    }

    public double getCharWidthByStringBounds(char ch) {
        FontRenderContext frc = new FontRenderContext(null, this.antiAlias, this.fractionalMetrics);
        Rectangle2D rectangle = this.font.getStringBounds(String.valueOf(ch), frc);
        double width = rectangle.getWidth();
        return width;
    }

    public double getXOffsetByStringBounds(char ch) {
        FontRenderContext frc = new FontRenderContext(null, this.antiAlias, this.fractionalMetrics);
        Rectangle2D rectangle = this.font.getStringBounds(String.valueOf(ch), frc);
        double xOffset = rectangle.getX();
        return xOffset;
    }

    private double getMaxWidth(String testStr) {
        char[] chs;
        double maxCharWidth = 0.0;
        for (char ch : chs = testStr.toCharArray()) {
            double chWidth = this.getCharBoundsWidth(ch);
            if (!(chWidth > maxCharWidth)) continue;
            maxCharWidth = chWidth;
            this.maxWidthChar = ch;
        }
        return maxCharWidth;
    }

    private double getMaxWidthWithLsb(String testStr) {
        char[] chs;
        double maxCharWidth = 0.0;
        for (char ch : chs = testStr.toCharArray()) {
            float lsb = this.getLSB(ch);
            lsb = lsb > 0.0f ? lsb : 0.0f;
            double chWidth = this.getCharBoundsWidth(ch) + (double)lsb;
            if (!(chWidth > maxCharWidth)) continue;
            maxCharWidth = chWidth;
            this.maxWidthWithLsbChar = ch;
        }
        return maxCharWidth;
    }

    private char getMaxHeightChar(String testStr) {
        char[] chs;
        double maxCharHeight = 0.0;
        char maxHeightChar = '\u0000';
        for (char ch : chs = testStr.toCharArray()) {
            double chHeight = this.getCharBoundsHeight(ch);
            if (!(chHeight > maxCharHeight)) continue;
            maxCharHeight = chHeight;
            maxHeightChar = ch;
        }
        return maxHeightChar;
    }

    public float getRSB(char ch) {
        GlyphMetrics gm = this.font.createGlyphVector(this.frc, String.valueOf(ch)).getGlyphMetrics(0);
        float rsb = gm.getRSB();
        return rsb;
    }

    private float getLSB(char ch) {
        float lsb;
        GlyphMetrics gm = this.font.createGlyphVector(this.frc, String.valueOf(ch)).getGlyphMetrics(0);
        try {
            lsb = this.getLSB(gm);
        }
        catch (RuntimeException re) {
            Logger.warn(String.format("getLSB(%Xh): ", ch) + re.getMessage());
            lsb = 0.0f;
        }
        return lsb;
    }

    @Deprecated
    private float getLSB(GlyphVector gv, int idx) {
        float lsb;
        GlyphMetrics gm = gv.getGlyphMetrics(idx);
        try {
            lsb = this.getLSB(gm);
        }
        catch (RuntimeException re) {
            Logger.warn(re.getMessage());
            lsb = 0.0f;
        }
        return lsb;
    }

    private float getLSB(GlyphMetrics metrics) {
        double width = metrics.getBounds2D().getWidth();
        if (width < 0.0) {
            throw new RuntimeException(String.format("GlyphMetrics.getBounds2D().getWidth() returned the abnormal value %f.", width));
        }
        float lsb = metrics.getLSB();
        return lsb;
    }

    private double getMinLSB(String testStr) {
        char[] chs;
        double minLSB = 32767.0;
        block3: for (char ch : chs = testStr.toCharArray()) {
            switch (Character.getType(ch)) {
                case 6: 
                case 7: 
                case 8: 
                case 23: 
                case 27: {
                    continue block3;
                }
                default: {
                    double lsb = this.getLSB(ch);
                    if (!(lsb < minLSB)) continue block3;
                    this.minLSBChar = ch;
                    minLSB = lsb;
                }
            }
        }
        return minLSB;
    }

    private String getDisplayableChars(String str) {
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!this.font.canDisplay(c)) continue;
            builder.append(c);
        }
        String ret = new String(builder);
        return ret;
    }

    private FontMetrics getFontMetrics(Font font, boolean antiAlias, boolean fractionalMetrics) {
        BufferedImage workImage = new BufferedImage(8, 8, 6);
        Graphics2D g2 = workImage.createGraphics();
        g2.setFont(font);
        FontUtils.setAntiAlias(g2, antiAlias, fractionalMetrics);
        FontMetrics fontMetrics = g2.getFontMetrics();
        g2.dispose();
        return fontMetrics;
    }

    @Deprecated
    private String getUnicodeChars() {
        StringBuilder unicodeAllChars = new StringBuilder();
        block3: for (char ch = '\u0000'; ch < '\uffff'; ch = (char)(ch + '\u0001')) {
            switch (Character.getType(ch)) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (!this.font.canDisplay(ch)) continue;
            unicodeAllChars.append(ch);
        }
        String resultStr = unicodeAllChars.toString();
        return resultStr;
    }

    @Deprecated
    private String removeSpecialChars(String origStr) {
        char[] origChars = origStr.toCharArray();
        StringBuilder newStr = new StringBuilder();
        block3: for (char ch : origChars) {
            switch (Character.getType(ch)) {
                case 6: 
                case 7: 
                case 8: {
                    continue block3;
                }
                default: {
                    newStr.append(ch);
                }
            }
        }
        return newStr.toString();
    }

    public static String getStdSizingRefChars() {
        String referenceChars = CommonConfig.currentConfig.fontSizingRefChars.trim();
        if (referenceChars.length() == 0) {
            referenceChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        }
        return referenceChars;
    }
}

