/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.basic;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import xaero.common.XaeroMinimapSession;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;
import xaero.common.server.player.ServerPlayerData;

public class HandshakePacket
extends MinimapMessage<HandshakePacket> {
    private int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(1);
    }

    public void toBytes(ByteBuf u) {
        u.writeInt(this.networkVersion);
    }

    public void fromBytes(ByteBuf buffer) {
        this.networkVersion = buffer.readInt();
    }

    public static class ServerHandler
    implements ServerMessageConsumer<HandshakePacket> {
        @Override
        public void handle(MinecraftServer server, EntityPlayerMP player, HandshakePacket message) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements ClientMessageConsumer<HandshakePacket> {
        @Override
        public void handle(HandshakePacket message) {
            XaeroMinimapSession session = XaeroMinimapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMinimapProcessor().setServerModNetworkVersion(message.networkVersion);
            session.getModMain().getMessageHandler().sendToServer(new HandshakePacket());
        }
    }
}

