/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.lwjgl.input.Keyboard;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.GuiActionButton;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.widget.GuiWidgetButton;
import xaero.common.gui.widget.WidgetScreen;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    private boolean buttonClicked;
    private GuiTextField focusedField;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected String title;
    protected String screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    private GuiTextField searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    private boolean shouldSaveRadar;

    public GuiSettings(IXaeroMinimap modMain, String title, GuiScreen backScreen, GuiScreen escScreen) {
        super(modMain, backScreen, escScreen);
        this.title = title;
    }

    @Override
    public void func_73866_w_() {
        int verticalOffset;
        super.func_73866_w_();
        this.screenTitle = this.title;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiActionButton(this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, 200, 20, I18n.func_135052_a((String)"gui.xaero_back", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiSettings.this.goBack();
            }
        });
        int n = verticalOffset = this.canSearch ? 24 : 0;
        if (this.entries != null) {
            boolean canEditIngameSettings = ModSettings.canEditIngameSettings();
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch(this.modMain).toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList<ISettingEntry> filteredEntries = sortingList.stream().sorted().map(new Function<KeySortableByOther<ISettingEntry>, ISettingEntry>(){

                @Override
                public ISettingEntry apply(KeySortableByOther<ISettingEntry> sortingKey) {
                    return sortingKey.getKey();
                }
            }).collect(new Supplier<ArrayList<ISettingEntry>>(){

                @Override
                public ArrayList<ISettingEntry> get() {
                    return new ArrayList<ISettingEntry>();
                }
            }, new BiConsumer<ArrayList<ISettingEntry>, ISettingEntry>(){

                @Override
                public void accept(ArrayList<ISettingEntry> l, ISettingEntry entry) {
                    l.add(entry);
                }
            }, new BiConsumer<ArrayList<ISettingEntry>, ArrayList<ISettingEntry>>(){

                @Override
                public void accept(ArrayList<ISettingEntry> l, ArrayList<ISettingEntry> l2) {
                    l.addAll(l2);
                }
            });
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ConfigSettingEntry settingEntry;
                    ISettingEntry entry = filteredEntries.get(firstEntry + i);
                    GuiButton optionWidget = entry.createWidget(this.field_146294_l / 2 - 205 + i % 2 * 210, this.field_146295_m / 7 + verticalOffset + 24 * (i >> 1), 200, this.modMain, this.field_146294_l, canEditIngameSettings);
                    this.func_189646_b(optionWidget);
                    if (!(entry instanceof ConfigSettingEntry) || !(settingEntry = (ConfigSettingEntry)entry).usesWorldMapHardValue(this.modMain)) continue;
                    optionWidget.field_146124_l = false;
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle + " (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")";
        this.nextButton = new MyTinyButton(0, this.field_146294_l / 2 + 131, this.field_146295_m / 7 + 144 + verticalOffset, I18n.func_135052_a((String)"gui.xaero_next", (Object[])new Object[0]));
        this.prevButton = new MyTinyButton(0, this.field_146294_l / 2 - 205, this.field_146295_m / 7 + 144 + verticalOffset, I18n.func_135052_a((String)"gui.xaero_previous", (Object[])new Object[0]));
        if (this.maxPage > 0) {
            this.func_189646_b(this.nextButton);
            this.func_189646_b(this.prevButton);
            this.nextButton.field_146124_l = this.page < this.maxPage;
            this.prevButton.field_146124_l = this.page > 0;
        }
        this.modMain.getWidgetScreenHandler().initialize(this, this.field_146294_l, this.field_146295_m);
        if (this.canSearch) {
            boolean shouldFocusSearch = this.shouldRefocusSearch;
            this.shouldRefocusSearch = false;
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.func_146198_h();
            }
            this.searchField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7, 200, 20);
            this.searchField.func_146180_a(this.entryFilter);
            if (shouldFocusSearch) {
                this.setFocusedField(this.searchField);
                this.searchField.func_146195_b(true);
                this.searchField.func_146190_e(cursorPos);
                this.searchField.func_146199_i(cursorPos);
            }
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.canSearch) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        super.func_146284_a(par1GuiButton);
        this.buttonClicked = true;
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton == this.nextButton) {
                this.onNextButton();
                return;
            }
            if (par1GuiButton == this.prevButton) {
                this.onPrevButton();
                return;
            }
            try {
                if (par1GuiButton instanceof MySmallButton) {
                    this.modMain.getGuiHelper().openSettingsGui(((MySmallButton)par1GuiButton).returnModOptions());
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (par1GuiButton instanceof MySmallButton && ((MySmallButton)par1GuiButton).returnModOptions() != null) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                this.goBack();
            }
            if (par1GuiButton instanceof GuiWidgetButton) {
                this.modMain.getWidgetScreenHandler().handleButton(this, (GuiWidgetButton)par1GuiButton);
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.modMain.getWidgetScreenHandler().render(this, this.field_146294_l, this.field_146295_m, par1, par2, this.guiScaleFactor);
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 5, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
        if (this.canSearch) {
            if (!this.foundSomething) {
                this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 7 + 29, 0xFFFFFF);
            }
            if (!this.searchField.func_146206_l() && this.searchField.func_146179_b().isEmpty()) {
                Misc.setFieldText(this.searchField, I18n.func_135052_a((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.func_146190_e(0);
            }
            this.searchField.func_146194_f();
            if (!this.searchField.func_146206_l()) {
                Misc.setFieldText(this.searchField, this.entryFilter);
            }
        }
        this.renderTooltips(par1, par2, par3);
    }

    @Override
    public void addButtonVisible(GuiButton button) {
        this.func_189646_b(button);
    }

    @Override
    public <S extends GuiScreen> S getScreen() {
        return (S)this;
    }

    @Override
    protected void onExit(GuiScreen screen) {
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (this.shouldSaveRadar) {
            this.modMain.getEntityRadarCategoryManager().save();
        }
        super.onExit(screen);
    }

    @Override
    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.focusedField == null) {
            if (Misc.inputMatchesKeyBinding(false, par2, (KeyBinding)this.modMain.getSettingsKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.onClose();
            }
        } else {
            this.focusedField.func_146201_a(par1, par2);
        }
        if (this.canSearch) {
            this.updateSearch();
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.modMain.getWidgetScreenHandler().handleClick(this, this.field_146294_l, this.field_146295_m, mouseX, mouseY, this.guiScaleFactor);
        this.buttonClicked = false;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.canSearch) {
            if (this.searchField.func_146192_a(mouseX, mouseY, mouseButton)) {
                this.setFocusedField(this.searchField);
            } else {
                this.setFocusedField(null);
            }
        }
        if (!this.buttonClicked && Misc.inputMatchesKeyBinding(true, mouseButton, (KeyBinding)this.modMain.getSettingsKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.goBack();
        }
    }

    public void setFocusedField(GuiTextField focusedField) {
        if (this.focusedField != focusedField && this.focusedField != null) {
            this.focusedField.func_146195_b(false);
        }
        this.focusedField = focusedField;
    }

    protected void onNextButton() {
        ++this.page;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    protected void onPrevButton() {
        --this.page;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    protected static ISettingEntry[] entriesFromOptions(ModOptions[] options) {
        ISettingEntry[] result = new ISettingEntry[options.length];
        for (int i = 0; i < options.length; ++i) {
            result[i] = new ConfigSettingEntry(options[i]);
        }
        return result;
    }

    protected void resetConfirmResult(boolean result, GuiScreen parent, GuiScreen escScreen) {
        if (result) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
            try {
                this.modMain.resetSettings();
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
        this.modMain.getGuiHelper().onResetCancel(parent, escScreen);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.func_146206_l() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.func_146179_b()))) {
            this.entryFilter = this.searchField.func_146179_b();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    public void setShouldSaveRadar() {
        this.shouldSaveRadar = true;
    }
}

