/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ChatType;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;

public class ForgeEventHandler {
    public static final RenderGameOverlayEvent.ElementType[] OVERLAY_LAYERS = new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.HOTBAR, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.TEXT, RenderGameOverlayEvent.ElementType.POTION_ICONS, RenderGameOverlayEvent.ElementType.SUBTITLES, RenderGameOverlayEvent.ElementType.CHAT};
    private IXaeroMinimap modMain;
    private GuiScreen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ForgeEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiOptions) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((GuiScreen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (event.getGui() instanceof GuiMainMenu || event.getGui() instanceof GuiMultiplayer) {
            this.modMain.getSettings().resetServerSettings();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getGui() instanceof GuiScreenRealmsProxy && ((GuiScreenRealmsProxy)event.getGui()).func_154321_a() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "task");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(RealmsTasks.RealmsGetServerDetailsTask.class, "server");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((GuiScreenRealmsProxy)event.getGui()).func_154321_a())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        } else if ((event.getGui() instanceof GuiAddWaypoint || event.getGui() instanceof GuiWaypoints) && (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL))) {
            event.setGui(null);
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void handleRenderGameOverlayEventPreOverridable(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == OVERLAY_LAYERS[this.modMain.getSettings().renderLayerIndex]) {
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                this.modMain.getInterfaceRenderer().renderInterfaces(minimapSession, event.getPartialTicks());
                this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), event.getResolution());
                if (GuiIngameForge.renderCrosshairs && minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                    GuiIngameForge.renderCrosshairs = false;
                    this.crosshairDisabledByThisMod = true;
                }
            }
            OldAnimation.tick();
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (Keyboard.isKeyDown((int)1)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
        this.handleRenderGameOverlayEventPreOverridable(event);
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        IPotionEffectsPushBox potionEffectsPushBox;
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && (potionEffectsPushBox = this.modMain.getInterfaces().getPotionEffectPushBox()) != null) {
            potionEffectsPushBox.setActive(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.crosshairDisabledByThisMod) {
            GuiIngameForge.renderCrosshairs = true;
            this.crosshairDisabledByThisMod = false;
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().replaceAll("\u00a7.", "").split(":");
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        XaeroMinimapSession minimapSession;
        if (e.getMessage() == null) {
            return;
        }
        String text = e.getMessage().func_150254_d();
        if (text.contains("xaero_waypoint:") || text.contains("xaero-waypoint:")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(text, e);
        } else {
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(false);
                minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(false);
            }
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(true);
            }
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(true);
            }
        }
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replace("\u00a7", "").replace("r", "").replace(" ", "");
            this.modMain.getSettings().resetServerSettings();
            this.modMain.getSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            MinimapLogs.LOGGER.info("Code: " + code);
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getGui() instanceof GuiMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        InterfaceManager interfaceManager;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            minimapSession.getMinimapProcessor().getMinimapWriter().setClearBlockColours(true);
            minimapSession.getMinimapProcessor().getMinimapWriter().resetShortBlocks();
        }
        if ((interfaceManager = this.modMain.getInterfaces()) != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        InterfaceManager interfaceManager = this.modMain.getInterfaces();
        if (interfaceManager != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    @SubscribeEvent
    public void handlePlayerSetSpawnEvent(PlayerSetSpawnEvent event) {
        XaeroMinimapSession minimapSession;
        if (event.getEntityPlayer().field_70170_p instanceof WorldClient && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(event.getNewSpawn());
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        XaeroMinimapSession minimapSession;
        if (event.getWorld() instanceof WorldClient && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getEntityRadar().updateRadar(null, null, null, minimap);
        }
    }
}

