/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars.tileentity;

import cpw.mods.compactsolars.CompactSolars;
import cpw.mods.compactsolars.common.CompactSolarType;
import ic2.api.energy.prefab.BasicEnergyTe;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TileEntityCompactSolar
extends BasicEnergyTe.Source
implements ITickable,
IInventory,
IWrenchable {
    private static Random random = new Random();
    private CompactSolarType type;
    private NonNullList<ItemStack> inventory;
    private boolean initialized;
    public boolean theSunIsVisible;
    private int tick;
    private boolean noSunlight;

    public TileEntityCompactSolar() {
        this(CompactSolarType.LOW_VOLTAGE);
    }

    public TileEntityCompactSolar(CompactSolarType type) {
        super(type.maxStorage, type.ordinal() + 1);
        this.type = type;
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.tick = random.nextInt(64);
    }

    public void func_73660_a() {
        if (!this.initialized && this.field_145850_b != null) {
            this.noSunlight = this.field_145850_b.field_73011_w.func_177495_o();
            this.initialized = true;
        }
        if (this.noSunlight) {
            return;
        }
        if (this.tick-- == 0) {
            this.updateSunState();
            this.tick = 64;
        }
        int energyProduction = 0;
        if (this.theSunIsVisible && (CompactSolars.productionRate == 1 || random.nextInt(CompactSolars.productionRate) == 0)) {
            energyProduction = this.generateEnergy();
        }
        ((BasicSource)this.getEnergyBuffer()).addEnergy((double)energyProduction);
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && ((ItemStack)this.inventory.get(0)).func_77973_b() instanceof IElectricItem) {
            ((BasicSource)this.getEnergyBuffer()).charge((ItemStack)this.inventory.get(0));
        }
    }

    private void updateSunState() {
        this.theSunIsVisible = TileEntityCompactSolar.getSkyLight(this.func_145831_w(), this.field_174879_c.func_177984_a()) > 0.0f;
    }

    public static float getSkyLight(World world, BlockPos pos) {
        if (world.field_73011_w.func_177495_o()) {
            return 0.0f;
        }
        float sunBrightness = TileEntityCompactSolar.limit((float)Math.cos(world.func_72929_e(1.0f)) * 2.0f + 0.2f, 0.0f, 1.0f);
        if (!BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            sunBrightness *= 1.0f - world.func_72867_j(1.0f) * 5.0f / 16.0f;
            sunBrightness *= 1.0f - world.func_72819_i(1.0f) * 5.0f / 16.0f;
            sunBrightness = TileEntityCompactSolar.limit(sunBrightness, 0.0f, 1.0f);
        }
        return (float)world.func_175642_b(EnumSkyBlock.SKY, pos) / 15.0f * sunBrightness;
    }

    private int generateEnergy() {
        return this.type.getOutput();
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(index)).func_190916_E() == 0) {
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.type.name();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public EnumFacing getFacing(World world, BlockPos pos) {
        return EnumFacing.field_82609_l[0];
    }

    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }

    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.size(); ++slot) {
            if (((ItemStack)this.inventory.get(slot)).func_190926_b()) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)slot);
            ((ItemStack)this.inventory.get(slot)).func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList tagList = compound.func_150295_c("Items", 9);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int itemCount = 0; itemCount < tagList.func_74745_c(); ++itemCount) {
            NBTTagCompound itemCompound = tagList.func_150305_b(itemCount);
            int slot = itemCompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set(slot, (Object)new ItemStack(itemCompound));
        }
    }

    public CompactSolarType getType() {
        return this.type;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.inventory.get(index);
            this.inventory.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        return Arrays.asList(new ItemStack((Block)CompactSolars.compactSolarBlock, 1, this.getType().ordinal()));
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IElectricItem;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static float limit(float value, float min, float max) {
        if (Float.isNaN(value) || value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }
}

