/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tonius.simplyjetpacks.util.ItemHelper;

public class OreDictionaryProxy {
    public ItemStack getOre(String oreName) {
        if (!this.oreNameExists(oreName)) {
            return null;
        }
        return ItemHelper.cloneStack((ItemStack)OreDictionary.getOres((String)oreName).get(0), 1);
    }

    public int getPrimaryOreID(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        return oreIDs.length > 0 ? oreIDs[0] : -1;
    }

    public String getPrimaryOreName(ItemStack stack) {
        return this.getOreName(this.getPrimaryOreID(stack));
    }

    public List<Integer> getOreIDs(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<Integer> oreIDs = new ArrayList<Integer>();
        for (int id : ids) {
            oreIDs.add(id);
        }
        return oreIDs;
    }

    public int getOreID(String oreName) {
        return OreDictionary.getOreID((String)oreName);
    }

    public List<String> getOreNames(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> oreNames = new ArrayList<String>();
        for (int oreID : oreIDs) {
            oreNames.add(OreDictionary.getOreName((int)oreID));
        }
        return oreNames;
    }

    public String getOreName(int oreID) {
        return OreDictionary.getOreName((int)oreID);
    }

    public boolean isOreIDEqual(ItemStack stack, int oreID) {
        int[] oreIDs;
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreID != id) continue;
            return true;
        }
        return false;
    }

    public boolean isOreNameEqual(ItemStack stack, String oreName) {
        List<String> oreNames = this.getOreNames(stack);
        for (String name : oreNames) {
            if (!oreName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean oreNameExists(String oreName) {
        return OreDictionary.doesOreNameExist((String)oreName);
    }
}

