/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.FilteredFluidTank;
import net.ndrei.teslacorelib.inventory.FluidTank;
import net.ndrei.teslacorelib.inventory.IFilteredFluidTank;
import net.ndrei.teslacorelib.inventory.IFluidTankWrapper;
import net.ndrei.teslacorelib.inventory.ISerializableFluidTank;
import net.ndrei.teslacorelib.utils.FluidextensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 02\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000bH\u0016J$\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010 H\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u001a\u0010%\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010&\u001a\u00020\u000bH\u0016J\u000e\u0010'\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016\u00a2\u0006\u0002\u0010+J\u0011\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070)\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010.\u001a\u00020\u0003H\u0016J\u0006\u0010/\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00061"}, d2={"Lnet/ndrei/teslacorelib/inventory/FluidStorage;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "()V", "tanks", "", "Lnet/minecraftforge/fluids/IFluidTank;", "getTanks", "()Ljava/util/List;", "acceptsFluidFrom", "", "bucket", "Lnet/minecraft/item/ItemStack;", "addTank", "Lnet/ndrei/teslacorelib/inventory/FilteredFluidTank;", "acceptedFluid", "Lnet/minecraftforge/fluids/Fluid;", "capacity", "", "Lnet/ndrei/teslacorelib/inventory/ColoredFluidHandler;", "tank", "color", "Lnet/minecraft/item/EnumDyeColor;", "name", "", "boundingBox", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "", "deserializeNBT", "nbt", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "doDrain", "filter", "resource", "fill", "doFill", "fillFluidFrom", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/IFluidTank;", "removeTank", "serializeNBT", "tankCount", "Companion", "tesla-core-lib"})
public class FluidStorage
implements IFluidHandler,
INBTSerializable<NBTTagCompound> {
    @NotNull
    private final List<IFluidTank> tanks;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final List<IFluidTank> getTanks() {
        return this.tanks;
    }

    @NotNull
    public IFluidTankProperties[] getTankProperties() {
        Collection $receiver$iv;
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank2 : this.tanks) {
            boolean canDrain = true;
            boolean canFill = true;
            if (tank2 instanceof IFilteredFluidTank) {
                canDrain = ((IFilteredFluidTank)tank2).canDrain();
                canFill = ((IFilteredFluidTank)tank2).canFill();
            }
            list.add(new FluidTankProperties(tank2.getFluid(), tank2.getCapacity(), canFill, canDrain));
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        Collection collection = $receiver$iv = (Collection)arrayList;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IFluidTankProperties[] iFluidTankPropertiesArray = thisCollection$iv.toArray(new IFluidTankProperties[0]);
        if (iFluidTankPropertiesArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return iFluidTankPropertiesArray;
    }

    public int fill(@Nullable FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack source = resource.copy();
        int used = 0;
        for (IFluidTank tank2 : this.tanks) {
            if (tank2 instanceof IFilteredFluidTank) {
                if (!((IFilteredFluidTank)tank2).canFill()) continue;
                IFilteredFluidTank iFilteredFluidTank = (IFilteredFluidTank)tank2;
                FluidStack fluidStack = source;
                Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"source");
                if (!iFilteredFluidTank.acceptsFluid(fluidStack)) continue;
            }
            int amount = tank2.fill(source, doFill);
            used += Math.min(amount, source.amount);
            if (source.amount <= amount) break;
            source.amount -= amount;
        }
        return used;
    }

    @Nullable
    public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(resource.amount, doDrain, resource);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain, null);
    }

    private final FluidStack drain(int maxDrain, boolean doDrain, FluidStack filter) {
        FluidStack fluid;
        FluidStack currentFilter = filter;
        FluidStack fluidStack = fluid = currentFilter == null ? null : currentFilter.copy();
        if (fluid != null) {
            fluid.amount = 0;
        }
        for (IFluidTank tank2 : this.tanks) {
            FluidStack drained;
            FluidStack contained;
            if (tank2 instanceof IFilteredFluidTank && !((IFilteredFluidTank)tank2).canDrain()) continue;
            if (tank2.getFluid() == null) {
                continue;
            }
            if (currentFilter != null && !contained.isFluidEqual(currentFilter)) continue;
            if (tank2.drain(maxDrain - (fluid == null ? 0 : fluid.amount), doDrain) == null) {
                continue;
            }
            if (fluid == null) {
                fluid = drained.copy();
                if (currentFilter == null) {
                    currentFilter = fluid;
                }
            } else {
                fluid.amount += drained.amount;
            }
            if (fluid == null || fluid.amount < maxDrain) continue;
            break;
        }
        return fluid != null && fluid.amount == 0 ? null : fluid;
    }

    @NotNull
    public final IFluidTank[] getTanks() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.tanks;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IFluidTank[] iFluidTankArray = thisCollection$iv.toArray(new IFluidTank[0]);
        if (iFluidTankArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return iFluidTankArray;
    }

    public final void addTank(@NotNull IFluidTank tank2) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        this.tanks.add(tank2);
    }

    @NotNull
    public final FilteredFluidTank addTank(@NotNull Fluid acceptedFluid, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)acceptedFluid, (String)"acceptedFluid");
        FilteredFluidTank tank2 = new FilteredFluidTank(acceptedFluid, new FluidTank(capacity));
        this.addTank(tank2);
        return tank2;
    }

    @NotNull
    public final ColoredFluidHandler addTank(@NotNull Fluid acceptedFluid, @NotNull IFluidTank tank2, @NotNull EnumDyeColor color, @NotNull String name, @NotNull BoundingRectangle boundingBox) {
        Intrinsics.checkParameterIsNotNull((Object)acceptedFluid, (String)"acceptedFluid");
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)boundingBox, (String)"boundingBox");
        ColoredFluidHandler colored = new ColoredFluidHandler(acceptedFluid, tank2, color, name, boundingBox);
        this.addTank(colored);
        return colored;
    }

    public final void removeTank(@NotNull IFluidTank tank2) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        this.tanks.removeIf(new Predicate<IFluidTank>(tank2){
            final /* synthetic */ IFluidTank $tank;

            public final boolean test(@NotNull IFluidTank t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                return net.ndrei.teslacorelib.inventory.FluidStorage$Companion.access$isSameTank(FluidStorage.Companion, this.$tank, t);
            }
            {
                this.$tank = iFluidTank;
            }
        });
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IFluidTank rawTank : this.tanks) {
            NBTTagCompound tankNbt;
            FilteredFluidTank tank2;
            FilteredFluidTank filteredFluidTank;
            IFluidTank iFluidTank = rawTank;
            if (!(iFluidTank instanceof FilteredFluidTank)) {
                iFluidTank = null;
            }
            if ((filteredFluidTank = (FilteredFluidTank)iFluidTank) == null || (filteredFluidTank = filteredFluidTank.getInnerTank()) == null) {
                filteredFluidTank = tank2 = rawTank;
            }
            if (tank2 instanceof ISerializableFluidTank) {
                NBTBase nBTBase = ((ISerializableFluidTank)((Object)tank2)).serializeNBT();
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTBase, (String)"tank.serializeNBT()");
                tankNbt = (NBTTagCompound)nBTBase;
            } else {
                tankNbt = new NBTTagCompound();
                FluidStack fluid = tank2.getFluid();
                if (fluid != null) {
                    fluid.writeToNBT(tankNbt);
                } else {
                    tankNbt.func_74757_a("_empty", true);
                }
            }
            list.func_74742_a((NBTBase)tankNbt);
        }
        nbt.func_74782_a("tanks", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        NBTTagList list;
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        NBTTagList nBTTagList = list = nbt.func_150297_b("tanks", 9) ? nbt.func_150295_c("tanks", 10) : null;
        if (list != null) {
            for (int index = 0; index < list.func_74745_c() && index < this.tanks.size(); ++index) {
                int filled;
                FluidStack fluid;
                IFluidTank tank2 = this.tanks.get(index);
                if (tank2 instanceof FilteredFluidTank) {
                    tank2 = ((FilteredFluidTank)tank2).getInnerTank();
                }
                NBTTagCompound tankNbt = list.func_150305_b(index);
                if (tank2 instanceof ISerializableFluidTank) {
                    ((ISerializableFluidTank)tank2).deserializeNBT((NBTBase)tankNbt);
                    continue;
                }
                FluidStack fluidStack = fluid = tankNbt.func_74764_b("_empty") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankNbt);
                if (tank2.getFluidAmount() > 0) {
                    tank2.drain(tank2.getFluidAmount(), true);
                }
                if (fluid == null || (filled = tank2.fill(fluid, true)) == fluid.amount) continue;
                TeslaCoreLib.INSTANCE.getLogger().warn("FluidTank deserialized fluid wasn't totally put into tank: " + fluid.toString());
            }
        }
    }

    public final int tankCount() {
        return this.tanks.size();
    }

    public final boolean acceptsFluidFrom(@NotNull ItemStack bucket) {
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        return FluidextensionsKt.canFillFrom((Iterable<? extends IFluidTank>)this.tanks, bucket);
    }

    @NotNull
    public final ItemStack fillFluidFrom(@NotNull ItemStack bucket) {
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        return FluidextensionsKt.fillFrom((Iterable<? extends IFluidTank>)this.tanks, bucket);
    }

    public FluidStorage() {
        List list;
        FluidStorage fluidStorage = this;
        fluidStorage.tanks = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\b"}, d2={"Lnet/ndrei/teslacorelib/inventory/FluidStorage$Companion;", "", "()V", "isSameTank", "", "a", "Lnet/minecraftforge/fluids/IFluidTank;", "b", "tesla-core-lib"})
    public static final class Companion {
        private final boolean isSameTank(IFluidTank a, IFluidTank b) {
            if (Intrinsics.areEqual((Object)a, (Object)b)) {
                return true;
            }
            if (a != null && b != null && b instanceof IFluidTankWrapper) {
                return Companion.isSameTank(a, ((IFluidTankWrapper)b).getInnerTank());
            }
            return false;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isSameTank(Companion $this, @Nullable IFluidTank a, @Nullable IFluidTank b) {
            return $this.isSameTank(a, b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

