/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElementRenderer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementCollector;
import xaero.map.radar.tracker.PlayerTrackerMapElementReader;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderContext;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderProvider;
import xaero.map.radar.tracker.TrackedPlayerIconManager;

public final class PlayerTrackerMapElementRenderer
extends MapElementRenderer<PlayerTrackerMapElement<?>, PlayerTrackerMapElementRenderContext, PlayerTrackerMapElementRenderer> {
    private final PlayerTrackerMapElementCollector elementCollector;
    private TrackedPlayerIconManager trackedPlayerIconManager;

    private PlayerTrackerMapElementRenderer(PlayerTrackerMapElementCollector elementCollector, PlayerTrackerMapElementRenderContext context, PlayerTrackerMapElementRenderProvider<PlayerTrackerMapElementRenderContext> provider, PlayerTrackerMapElementReader reader) {
        super(context, provider, reader);
        this.elementCollector = elementCollector;
    }

    public TrackedPlayerIconManager getTrackedPlayerIconManager() {
        return this.trackedPlayerIconManager;
    }

    @Override
    public void beforeRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
    }

    @Override
    public void afterRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        if (!pre) {
            this.elementCollector.resetRenderedOnRadarFlags();
        }
    }

    @Override
    public void renderElementPre(int location, PlayerTrackerMapElement<?> element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, FontRenderer fontRenderer, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
    }

    @Override
    public boolean renderElement(int location, PlayerTrackerMapElement<?> e, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, FontRenderer fontRenderer, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175102_a(e.getPlayerId());
        if (info != null) {
            boolean firstTime;
            EntityPlayer clientPlayer = mc.field_71441_e.func_152378_a(e.getPlayerId());
            GlStateManager.func_179094_E();
            double fadeDest = hovered ? 1.0 : 0.0;
            boolean bl = firstTime = e.getFadeAnim() == null;
            if (firstTime || e.getFadeAnim().getDestination() != fadeDest) {
                e.setFadeAnim(new SlowingAnimation(e.getFadeAnim() == null ? 0.0 : e.getFadeAnim().getCurrent(), fadeDest, 0.8, 0.001));
            }
            float alpha = (float)e.getFadeAnim().getCurrent();
            if (!e.wasRenderedOnRadar() || alpha > 0.0f) {
                if (alpha > 0.0f) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                    String name = info.func_178845_a().getName();
                    int nameWidth = fontRenderer.func_78256_a(name);
                    Gui.func_73734_a((int)(-8 - nameWidth - 2), (int)-6, (int)-7, (int)6, (int)((int)(alpha * 119.0f) << 24));
                    GlStateManager.func_179147_l();
                    int textAlphaComponent = (int)(alpha * 255.0f);
                    if (textAlphaComponent > 3) {
                        int tc = 0xFFFFFF | textAlphaComponent << 24;
                        fontRenderer.func_175063_a(name, (float)(-8 - nameWidth), -4.0f, tc);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.func_179137_b((double)partialX, (double)partialY, (double)0.0);
                GlStateManager.func_179152_a((float)((2.0f + alpha) / 3.0f), (float)((2.0f + alpha) / 3.0f), (float)1.0f);
                XaeroIcon icon = this.getTrackedPlayerIconManager().getIcon(clientPlayer, info, e, scaledRes);
                XaeroIconAtlas atlas = icon.getTextureAtlas();
                GlStateManager.func_179144_i((int)atlas.getTextureId());
                Gui.func_152125_a((int)-15, (int)-15, (float)(icon.getOffsetX() + 1), (float)(icon.getOffsetY() + 31), (int)30, (int)-30, (int)30, (int)30, (float)atlas.getWidth(), (float)atlas.getWidth());
            }
            GlStateManager.func_179121_F();
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return WorldMap.settings.trackedPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMapElementCollector getCollector() {
        return this.elementCollector;
    }

    public void update(Minecraft mc) {
        if (this.trackedPlayerIconManager == null) {
            this.trackedPlayerIconManager = TrackedPlayerIconManager.Builder.begin().build();
        }
        this.elementCollector.update(mc);
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMapElementRenderer build() {
            PlayerTrackerMapElementCollector collector = new PlayerTrackerMapElementCollector(WorldMap.playerTrackerSystemManager, new Runnable(){

                @Override
                public void run() {
                    WorldMap.trackedPlayerMenuRenderer.updateFilteredList();
                }
            });
            return new PlayerTrackerMapElementRenderer(collector, new PlayerTrackerMapElementRenderContext(), new PlayerTrackerMapElementRenderProvider(collector), new PlayerTrackerMapElementReader());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

