/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.ConfirmScreenBase;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapTpCommand;
import xaero.map.gui.GuiPlayerTpCommand;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

public class GuiWorldMapSettings
extends GuiSettings {
    public static final CursorBox PLAYER_TELEPORT_COMMAND_TOOLTIP = new CursorBox("gui.xaero_wm_box_player_teleport_command");

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(GuiScreen parent) {
        this(parent, null);
    }

    public GuiWorldMapSettings(GuiScreen parent, final GuiScreen escapeScreen) {
        super(I18n.func_135052_a((String)"gui.xaero_world_map_settings", (Object[])new Object[0]), parent, escapeScreen);
        ScreenSwitchSettingEntry minimapEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_minimap_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return SupportMods.xaeroMinimap.openSettingsScreen(GuiWorldMapSettings.this.field_146297_k, GuiWorldMapSettings.this, escape);
            }
        }, !SupportMods.minimap() ? ModOptions.REQUIRES_MINIMAP : null, SupportMods.minimap());
        ScreenSwitchSettingEntry resetEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_reset_defaults", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new ConfirmScreenBase(current, escape, true, new GuiYesNoCallback(){

                    public void func_73878_a(boolean r, int i) {
                        GuiWorldMapSettings.this.resetConfirmResult(r, GuiWorldMapSettings.this, escapeScreen);
                    }
                }, I18n.func_135052_a((String)"gui.xaero_wm_reset_message", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_wm_reset_message2", (Object[])new Object[0]), 0);
            }
        }, null, true);
        ScreenSwitchSettingEntry mapTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_teleport_command", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMapTpCommand(current, escape);
            }
        }, !ModSettings.canEditIngameSettings() ? ModOptions.REQUIRES_INGAME : null, ModSettings.canEditIngameSettings());
        ScreenSwitchSettingEntry pacTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_player_teleport_command", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiPlayerTpCommand(current, escape);
            }
        }, !ModSettings.canEditIngameSettings() ? ModOptions.REQUIRES_INGAME : PLAYER_TELEPORT_COMMAND_TOOLTIP, ModSettings.canEditIngameSettings());
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.LIGHTING), new ConfigSettingEntry(ModOptions.COLOURS), new ConfigSettingEntry(ModOptions.LOAD), new ConfigSettingEntry(ModOptions.UPDATE), new ConfigSettingEntry(ModOptions.DEPTH), new ConfigSettingEntry(ModOptions.SLOPES), new ConfigSettingEntry(ModOptions.STEPS), new ConfigSettingEntry(ModOptions.COORDINATES), new ConfigSettingEntry(ModOptions.WAYPOINTS), new ConfigSettingEntry(ModOptions.WAYPOINT_BACKGROUNDS), new ConfigSettingEntry(ModOptions.WAYPOINT_SCALE), minimapEntry, new ConfigSettingEntry(ModOptions.BIOME_BLENDING), new ConfigSettingEntry(ModOptions.BIOMES), new ConfigSettingEntry(ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS), new ConfigSettingEntry(ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS), new ConfigSettingEntry(ModOptions.FLOWERS), new ConfigSettingEntry(ModOptions.DISPLAY_STAINED_GLASS), new ConfigSettingEntry(ModOptions.IGNORE_HEIGHTMAPS), new ConfigSettingEntry(ModOptions.CAVE_MODE_DEPTH), new ConfigSettingEntry(ModOptions.AUTO_CAVE_MODE), new ConfigSettingEntry(ModOptions.LEGIBLE_CAVE_MAPS), new ConfigSettingEntry(ModOptions.CAVE_MODE_TOGGLE_TIMER), new ConfigSettingEntry(ModOptions.DEFAULT_CAVE_MODE_TYPE), new ConfigSettingEntry(ModOptions.DISPLAY_CAVE_MODE_START), new ConfigSettingEntry(ModOptions.ARROW), new ConfigSettingEntry(ModOptions.OPEN_ANIMATION), new ConfigSettingEntry(ModOptions.ARROW_COLOUR), new ConfigSettingEntry(ModOptions.DISPLAY_ZOOM), new ConfigSettingEntry(ModOptions.HOVERED_BIOME), new ConfigSettingEntry(ModOptions.ZOOM_BUTTONS), new ConfigSettingEntry(ModOptions.DETECT_AMBIGUOUS_Y), mapTeleportCommandEntry, pacTeleportCommandEntry, new ConfigSettingEntry(ModOptions.MAP_TELEPORT_ALLOWED), new ConfigSettingEntry(ModOptions.PARTIAL_Y_TELEPORTATION), new ConfigSettingEntry(ModOptions.UPDATE_NOTIFICATION), new ConfigSettingEntry(ModOptions.RELOAD), new ConfigSettingEntry(ModOptions.DEBUG), resetEntry};
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        final CursorBox closeSettingsTooltip = new CursorBox((ITextComponent)new TextComponentTranslation("gui.xaero_box_close_settings", new Object[]{Misc.getKeyName(ControlsRegister.keyOpenSettings)}));
        if (this.parent instanceof GuiMap) {
            this.func_189646_b(new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    GuiWorldMapSettings.this.onSettingsButton(b);
                }
            }, new Supplier<CursorBox>(){

                @Override
                public CursorBox get() {
                    return closeSettingsTooltip;
                }
            }));
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
    }

    private void onSettingsButton(GuiButton button) {
        this.goBack();
    }
}

