/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.YesNoCallbackImplementation;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.gui.dropdown.IDropDownWidgetCallback;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private DropDownWidget createdDropdown;
    private GuiButton switchingButton;
    private GuiButton multiworldTypeOptionButton;
    private GuiButton renameButton;
    private GuiButton deleteButton;
    private GuiButton confirmButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        this.createdDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        this.settingsDimension = mapScreen.getDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null && this.settingsDimension.getMapWorld().isMultiplayer();
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, height - 20);
            mapScreen.addGuiButton(this.switchingButton);
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                if (this.active) {
                    this.createdDropdown = this.createDropdown(this.uiPausedOnUpdate, width, mapScreen, minecraft);
                    mapScreen.addWidget(this.createdDropdown);
                    this.multiworldTypeOptionButton = new TooltipButton(width / 2 - 90, 24, 180, 20, this.getMultiworldTypeButtonMessage(), new Supplier<CursorBox>(){

                        @Override
                        public CursorBox get() {
                            return GuiMapSwitching.this.settingsDimension.isFutureMultiworldServerBased() ? GuiMapSwitching.this.serverSelectionModeBox : GuiMapSwitching.this.mapSelectionBox;
                        }
                    }){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void onPress() {
                            Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiPauseSync;
                            synchronized (object) {
                                if (GuiMapSwitching.this.isMapSelectionOptionEnabled()) {
                                    GuiMapSwitching.this.mapProcessor.toggleMultiworldType(GuiMapSwitching.this.settingsDimension);
                                    ((GuiMapSwitching)GuiMapSwitching.this).multiworldTypeOptionButton.field_146126_j = GuiMapSwitching.this.getMultiworldTypeButtonMessage();
                                }
                            }
                        }
                    };
                    mapScreen.addGuiButton(this.multiworldTypeOptionButton);
                    this.renameButton = new GuiButton(-1, width / 2 + 109, 60, 60, 20, I18n.func_135052_a((String)"gui.xaero_rename", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.renameButton);
                    this.deleteButton = new GuiButton(-1, width / 2 - 168, 60, 60, 20, I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.deleteButton);
                    this.confirmButton = new GuiButton(200, width / 2 - 50, 84, 100, 20, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.confirmButton);
                    this.updateButtons(mapScreen, width, minecraft);
                } else {
                    this.switchingButton.field_146124_l = this.canToggleThisScreen();
                }
            } else {
                this.switchingButton.field_146124_l = false;
            }
        }
    }

    private DropDownWidget createDropdown(boolean paused, final int width, final GuiMap mapScreen, final Minecraft minecraft) {
        ArrayList<String> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther<String>(mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            Collections.sort(sortableList);
            ArrayList<String> dropdownValuesList = new ArrayList<String>();
            for (KeySortableByOther keySortableByOther : sortableList) {
                dropdownValuesList.add((String)keySortableByOther.getKey());
            }
            selected = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
            if (selected == dropdownValuesList.size()) {
                dropdownValuesList.add(currentMultiworld);
            }
            this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
            mwDropdownNames = new ArrayList();
            for (String string : dropdownValuesList) {
                mwDropdownNames.add(this.settingsDimension.getMultiworldName(string));
            }
            if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                mwDropdownNames.add("\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
            }
        } else {
            mwDropdownNames = new ArrayList<String>();
            this.mwDropdownValues = null;
            mwDropdownNames.add("\u00a77" + I18n.func_135052_a((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]));
        }
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(mwDropdownNames.toArray(new String[0])).setX(width / 2 - 100).setY(64).setW(200).setSelected(selected).setCallback(new IDropDownWidgetCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onSelected(DropDownWidget dd, int i) {
                Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (GuiMapSwitching.this.isUIPaused() || GuiMapSwitching.this.uiPausedOnUpdate) {
                        return false;
                    }
                    if (i < GuiMapSwitching.this.mwDropdownValues.length) {
                        GuiMapSwitching.this.mapProcessor.setMultiworld(GuiMapSwitching.this.settingsDimension, GuiMapSwitching.this.mwDropdownValues[i]);
                        GuiMapSwitching.this.updateButtons(mapScreen, width, minecraft);
                        return true;
                    }
                    minecraft.func_147108_a((GuiScreen)new GuiMapName(GuiMapSwitching.this.mapProcessor, mapScreen, mapScreen, GuiMapSwitching.this.settingsDimension, null));
                    return false;
                }
            }
        }).setContainer(mapScreen).setNarrationTitle(I18n.func_135052_a((String)"gui_xaero_wm_dropdown_map_select", (Object[])new Object[0])).build();
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(GuiMap mapScreen, int width, Minecraft minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                DropDownWidget newDropDown;
                DropDownWidget dropDownWidget = newDropDown = !this.active ? null : this.createDropdown(isPaused, width, mapScreen, minecraft);
                if (newDropDown != null) {
                    if (this.createdDropdown != null) {
                        mapScreen.replaceWidget(this.createdDropdown, newDropDown);
                    } else {
                        mapScreen.addWidget(newDropDown);
                    }
                } else if (this.createdDropdown != null) {
                    mapScreen.removeWidget(this.createdDropdown);
                }
                this.createdDropdown = !this.active ? null : newDropDown;
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.field_146124_l = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.field_146124_l = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.field_146124_l = this.canRenameMap();
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.field_146124_l = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.field_146124_l = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.func_135052_a((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.func_146280_a(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdDropdown == null || this.createdDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && this.createdDropdown.isClosed() && !this.uiPausedOnUpdate && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[this.createdDropdown.getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    public void renderText(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.func_135052_a((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        MapRenderHelper.drawStringWithBackground(minecraft.field_71466_p, selectMapString, width / 2 - minecraft.field_71466_p.func_78256_a(selectMapString) / 2, 49, -1, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public void postMapRender(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(final GuiMap mapScreen, final Minecraft minecraft, final int width, final int height, GuiButton b) {
        if (b.field_146124_l) {
            if (b == this.switchingButton) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canToggleThisScreen()) {
                        return;
                    }
                    this.active = !this.active;
                    mapScreen.func_146280_a(minecraft, width, height);
                }
            }
            if (b == this.renameButton) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canRenameMap()) {
                        return;
                    }
                    minecraft.func_147108_a((GuiScreen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
                }
            }
            if (b == this.deleteButton) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canDeleteMap()) {
                        return;
                    }
                    final String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                    minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                        @Override
                        public void func_73878_a(boolean result, int id) {
                            if (result) {
                                String mapNameAndIdLine = I18n.func_135052_a((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + GuiMapSwitching.this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void func_73878_a(boolean result2, int id) {
                                        if (result2) {
                                            Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (GuiMapSwitching.this.mapProcessor.getMapWorld() == GuiMapSwitching.this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !GuiMapSwitching.this.mapProcessor.isMapWorldUsable() ? null : GuiMapSwitching.this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (GuiMapSwitching.this.settingsDimension == currentDimension && GuiMapSwitching.this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Delayed map deletion!");
                                                        }
                                                        GuiMapSwitching.this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Instant map deletion!");
                                                        }
                                                        GuiMapSwitching.this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    GuiMapSwitching.this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    GuiMapSwitching.this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    GuiMapSwitching.this.settingsDimension.saveConfigUnsynced();
                                                    ((GuiMapSwitching)GuiMapSwitching.this).settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.func_146280_a(minecraft, width, height);
                                                }
                                            }
                                        }
                                        minecraft.func_147108_a((GuiScreen)mapScreen);
                                    }
                                }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg3", (Object[])new Object[0]), mapNameAndIdLine, -1));
                            } else {
                                minecraft.func_147108_a((GuiScreen)mapScreen);
                            }
                        }
                    }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_map_msg2", (Object[])new Object[0]), -1));
                }
            }
            if (b.field_146127_k == 200) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canConfirm()) {
                        return;
                    }
                    this.confirm(mapScreen, minecraft, width, height);
                }
            }
        }
    }
}

