/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.File;
import java.io.IOException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;

public class WorldDataHandler {
    private final Executor renderExecutor;
    private WorldDataReader reader;
    private WorldServer worldServer;
    private File worldDir;

    public WorldDataHandler(WorldDataReader reader, Executor renderExecutor) {
        this.reader = reader;
        this.renderExecutor = renderExecutor;
    }

    public void handleRenderExecutor() {
        this.renderExecutor.drainTasks();
    }

    public void prepareSingleplayer(World world, MapProcessor mapProcessor) {
        String worldId = mapProcessor.getCurrentWorldId();
        if (world != null && !mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(worldId), worldId)) {
            this.worldServer = DimensionManager.getWorld((int)world.field_73011_w.getDimension(), (boolean)false);
            this.worldDir = this.worldServer != null ? this.worldServer.getChunkSaveLocation() : null;
        } else {
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, World world, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldServer == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        ServerWorldLoaded loadedCap = (ServerWorldLoaded)this.worldServer.getCapability(ServerWorldCapabilities.LOADED_CAP, null);
        if (loadedCap != null) {
            boolean shouldCancel = false;
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                if (loadedCap.loaded) {
                    boolean buildResult = this.reader.buildRegion(region, this.worldDir, world, loading, chunkCountDest, this.renderExecutor, this.worldServer);
                    Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                    return result;
                }
                shouldCancel = true;
            }
            if (shouldCancel) {
                WorldMap.LOGGER.info("Tried loading a region for an unloaded server world!");
                return Result.CANCEL;
            }
        }
        WorldMap.LOGGER.info("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(WorldServer sw) {
        ServerWorldLoaded loadedCap = (ServerWorldLoaded)sw.getCapability(ServerWorldCapabilities.LOADED_CAP, null);
        if (loadedCap != null) {
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                loadedCap.loaded = false;
            }
        }
    }

    public WorldServer getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.reader;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    Executor getWorldDataRenderExecutor() {
        return this.renderExecutor;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

