/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.GuiUpdateAll;
import xaero.map.patreon.Patreon;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiScreenRealmsProxy && ((GuiScreenRealmsProxy)event.getGui()).func_154321_a() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "task");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(RealmsTasks.RealmsGetServerDetailsTask.class, "server");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((GuiScreenRealmsProxy)event.getGui()).func_154321_a())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) throws IOException {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.getMapWriter().getColorTypeCache().updateGrassColor();
            mapProcessor.getMapWriter().requestCachedColoursClear();
            mapProcessor.getBlockStateShortShapeCache().reset();
        }
        if (SupportMods.minimap()) {
            WorldMap.waypointSymbolCreator.resetChars();
        }
        if (WorldMap.settings != null) {
            WorldMap.settings.updateRegionCacheHashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.phase == TickEvent.Phase.END) {
                ScaledResolution scaledresolution = new ScaledResolution(mc);
                mapProcessor.onRenderProcess(mc, scaledresolution);
                mc.field_71454_w = false;
                mapProcessor.resetRenderStartTime();
                Queue<FutureTask<?>> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(mapProcessor.getRenderStartTimeUpdater());
                Queue<FutureTask<?>> queue = minecraftScheduledTasks;
                synchronized (queue) {
                    FutureTask[] currentTasks = minecraftScheduledTasks.toArray(new FutureTask[0]);
                    minecraftScheduledTasks.clear();
                    minecraftScheduledTasks.add((FutureTask<?>)listenablefuturetask);
                    for (FutureTask t : currentTasks) {
                        minecraftScheduledTasks.add(t);
                    }
                }
            } else if (event.phase == TickEvent.Phase.START) {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.field_71462_r, true)) {
                    Misc.setShaderProgram(0);
                    ScaledResolution scaledresolution = new ScaledResolution(mc);
                    int i1 = scaledresolution.func_78326_a();
                    int j1 = scaledresolution.func_78328_b();
                    int k1 = Mouse.getX() * i1 / mc.field_71443_c;
                    int l1 = j1 - Mouse.getY() * j1 / mc.field_71440_d - 1;
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179083_b((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179096_D();
                    mc.field_71460_t.func_78478_c();
                    GlStateManager.func_179086_m((int)256);
                    ForgeHooksClient.drawScreen((GuiScreen)mc.field_71462_r, (int)k1, (int)l1, (float)0.0f);
                    mc.field_71454_w = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getGui() instanceof GuiMainMenu && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdateAll());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        WorldMapSession worldmapSession;
        if (event.getEntityPlayer().field_70170_p instanceof WorldClient && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(event.getNewSpawn(), (WorldClient)event.getEntityPlayer().field_70170_p);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof WorldServer) {
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)new ServerWorldCapabilities());
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.getWorld() == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.getWorld() instanceof WorldServer) {
            WorldServer sw = (WorldServer)event.getWorld();
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            String crosshairMessage;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
            String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
            if (crosshairMessage != null) {
                int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
                GlStateManager.func_179084_k();
                Minecraft.func_71410_x().field_71466_p.func_175063_a(crosshairMessage, (float)(event.getResolution().func_78326_a() / 2 - messageWidth / 2), (float)(event.getResolution().func_78328_b() / 2 + 60), -1);
                GlStateManager.func_179147_l();
            }
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        WorldMapSession worldmapSession;
        if (e.getMessage() == null) {
            return;
        }
        ITextComponent text = e.getMessage();
        String textString = text.func_150254_d();
        if (e.getType() == ChatType.SYSTEM && textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlay(false);
        }
        if (e.getType() == ChatType.SYSTEM && textString.contains("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlay(true);
        }
    }
}

