/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.outdated.identifier;

import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.outdated.identifier.LittleIdentifierAbsolute;
import java.security.InvalidParameterException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

@Deprecated
public class LittleIdentifierRelative {
    public BlockPos coord;
    public LittleGridContext context;
    public int[] identifier;

    public LittleIdentifierRelative(int relativeX, int relativeY, int relativeZ, LittleGridContext context, int[] identifier) {
        this.coord = new BlockPos(relativeX, relativeY, relativeZ);
        this.context = context;
        this.identifier = identifier;
    }

    public static LittleIdentifierRelative loadIdentifierOld(String id, NBTTagCompound nbt) {
        return new LittleIdentifierRelative(id, nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LittleIdentifierRelative(String id, NBTTagCompound nbt) {
        if (nbt.func_74764_b(id + "coord")) {
            int[] array = nbt.func_74759_k(id + "coord");
            if (array.length != 3) throw new InvalidParameterException("No valid coord given " + nbt);
            this.coord = new BlockPos(array[0], array[1], array[2]);
        } else {
            this.coord = nbt.func_74764_b(id + "coordX") ? new BlockPos(nbt.func_74762_e(id + "coordX"), nbt.func_74762_e(id + "coordY"), nbt.func_74762_e(id + "coordZ")) : new BlockPos(0, 0, 0);
        }
        if (nbt.func_74764_b(id + "pos")) {
            LittleVec position = new LittleVec(id + "pos", nbt);
            this.identifier = new int[]{position.x, position.y, position.z};
        } else {
            this.identifier = nbt.func_74759_k("id");
        }
        this.context = LittleGridContext.get(nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LittleIdentifierRelative(NBTTagCompound nbt) {
        if (nbt.func_74764_b("coord")) {
            int[] array = nbt.func_74759_k("coord");
            if (array.length != 3) throw new InvalidParameterException("No valid coord given " + nbt);
            this.coord = new BlockPos(array[0], array[1], array[2]);
        } else {
            this.coord = nbt.func_74764_b("coordX") ? new BlockPos(nbt.func_74762_e("coordX"), nbt.func_74762_e("coordY"), nbt.func_74762_e("coordZ")) : new BlockPos(0, 0, 0);
        }
        if (nbt.func_74764_b("pos")) {
            LittleVec position = new LittleVec("pos", nbt);
            this.identifier = new int[]{position.x, position.y, position.z};
        } else {
            this.identifier = nbt.func_74759_k("id");
        }
        this.context = LittleGridContext.get(nbt);
    }

    public BlockPos getAbsolutePosition(TileEntity te) {
        return this.getAbsolutePosition(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    public BlockPos getAbsolutePosition(BlockPos origin) {
        return this.getAbsolutePosition(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public BlockPos getAbsolutePosition(int x, int y, int z) {
        return new BlockPos(this.coord.func_177958_n() + x, this.coord.func_177956_o() + y, this.coord.func_177952_p() + z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74783_a("coord", new int[]{this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p()});
        nbt.func_74783_a("id", this.identifier);
        this.context.set(nbt);
        return nbt;
    }

    public int hashCode() {
        return this.coord.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleIdentifierRelative) {
            if (!this.coord.equals((Object)((LittleIdentifierRelative)obj).coord)) {
                return false;
            }
            return Arrays.equals(this.identifier, LittleIdentifierAbsolute.convertTo(((LittleIdentifierRelative)obj).identifier, ((LittleIdentifierRelative)obj).context, this.context));
        }
        return false;
    }

    public String toString() {
        return "coord:[" + this.coord.func_177958_n() + "," + this.coord.func_177956_o() + "," + this.coord.func_177952_p() + "]|position:" + Arrays.toString(this.identifier);
    }

    public LittleIdentifierRelative copy() {
        return new LittleIdentifierRelative(this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p(), this.context, (int[])this.identifier.clone());
    }

    @Deprecated
    public int generateIndex(BlockPos pos) {
        return LittleIdentifierRelative.generateIndex(pos.func_177971_a((Vec3i)this.coord), this.identifier, this.context);
    }

    @Deprecated
    public static int generateIndex(BlockPos resulted, int[] identifier, LittleGridContext context) {
        int[] array = LittleIdentifierAbsolute.convertTo(identifier, context, LittleGridContext.getMax());
        int index = resulted.func_177958_n() + (resulted.func_177956_o() << 4) + (resulted.func_177952_p() << 8);
        if (array.length > 2) {
            index += (array[0] << 12) + (array[1] << 16) + (array[2] << 20);
        }
        if (array.length > 3) {
            index += array[3] << 22;
        }
        if (array.length > 5) {
            index += (array[4] << 26) + (array[5] << 30);
        }
        return index;
    }
}

