/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.registry;

import com.creativemd.littletiles.common.block.BlockLTFlowingLava;
import com.creativemd.littletiles.common.block.BlockLTFlowingWater;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.registry.LittlePreviewType;
import com.creativemd.littletiles.common.tile.registry.LittleTileType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;

public class LittleTileRegistry {
    private static LinkedHashMap<Class<? extends LittleTile>, LittleTileType> tileIDs = new LinkedHashMap();
    private static LinkedHashMap<String, LittleTileType> invTileIDs = new LinkedHashMap();
    private static List<LittleTileType> typesOrdered = new ArrayList<LittleTileType>();
    private static LittleTileType defaultTileType;
    private static LinkedHashMap<String, LittlePreviewType> previewTypes;
    private static LinkedHashMap<Class<? extends LittlePreview>, LittlePreviewType> previewTypesInv;
    private static LittlePreviewType defaultPreviewType;

    public static LittleTileType getTileType(String id) {
        return invTileIDs.getOrDefault(id, defaultTileType);
    }

    public static LittleTileType getTileType(Class<? extends LittleTile> clazz) {
        return tileIDs.getOrDefault(clazz, defaultTileType);
    }

    public static LittleTileType registerTileType(Class<? extends LittleTile> clazz, String id, Predicate<NBTTagCompound> predicate, boolean saveId) {
        LittleTileType type = new LittleTileType(id, clazz, predicate, saveId);
        tileIDs.put(clazz, type);
        invTileIDs.put(id, type);
        typesOrdered.add(type);
        return type;
    }

    public static LittleTileType getTypeFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tID")) {
            return LittleTileRegistry.getTileType(nbt.func_74779_i("tID"));
        }
        for (int i = typesOrdered.size() - 1; i >= 0; --i) {
            if (!LittleTileRegistry.typesOrdered.get((int)i).predicate.test(nbt)) continue;
            return typesOrdered.get(i);
        }
        return defaultTileType;
    }

    public static LittleTile loadTile(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tileID")) {
            if (nbt.func_74764_b("block")) {
                Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                LittleBox box = new LittleBox(new LittleVec("i", nbt), new LittleVec("a", nbt));
                box.add(new LittleVec(8, 8, 8));
                LittleTile tile = new LittleTile(block, meta);
                tile.setBox(box);
                return tile;
            }
        } else {
            LittleTileType type = LittleTileRegistry.getTypeFromNBT(nbt);
            LittleTile tile = type.createTile();
            if (tile != null) {
                try {
                    tile.loadTile(nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return tile;
        }
        return null;
    }

    public static Class<? extends LittlePreview> getDefaultPreviewClass() {
        return LittlePreview.class;
    }

    public static LittlePreviewType registerPreviewType(String id, Class<? extends LittlePreview> clazz) {
        LittlePreviewType type = new LittlePreviewType(id, clazz);
        previewTypes.put(id, type);
        previewTypesInv.put(clazz, type);
        return type;
    }

    public static Class<? extends LittlePreview> getPreviewClass(String id) {
        return LittleTileRegistry.previewTypes.getOrDefault((Object)id, (LittlePreviewType)LittleTileRegistry.defaultPreviewType).clazz;
    }

    public static String getPreviewId(Class<? extends LittlePreview> clazz) {
        return LittleTileRegistry.previewTypesInv.getOrDefault(clazz, (LittlePreviewType)LittleTileRegistry.defaultPreviewType).id;
    }

    public static LittlePreview loadPreview(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt.func_74764_b("type")) {
            LittlePreviewType type = previewTypes.get(nbt.func_74779_i("type"));
            if (type == null) {
                type = defaultPreviewType;
            }
            if (type != null) {
                LittlePreview preview = null;
                try {
                    preview = type.clazz.getConstructor(NBTTagCompound.class).newInstance(nbt);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return preview;
            }
            throw new RuntimeException("Could find '" + nbt.func_74779_i("type") + "' preview type");
        }
        return new LittlePreview(nbt);
    }

    public static void initTiles() {
        defaultTileType = LittleTileRegistry.registerTileType(LittleTile.class, "BlockTileBlock", x -> true, false);
        LittleTileRegistry.registerTileType(LittleTileColored.class, "BlockTileColored", x -> x.func_74764_b("color"), false);
        defaultPreviewType = LittleTileRegistry.registerPreviewType("default", LittlePreview.class);
        LittlePreview.registerPreviewType("water", BlockLTFlowingWater.LittleFlowingWaterPreview.class);
        LittlePreview.registerPreviewType("lava", BlockLTFlowingLava.LittleFlowingLavaPreview.class);
    }

    static {
        previewTypes = new LinkedHashMap();
        previewTypesInv = new LinkedHashMap();
    }
}

