/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.place;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.EnumFacing;

public class PlacePreviewFacing
extends PlacePreview {
    public EnumFacing facing;
    public int color;

    public PlacePreviewFacing(LittleBox box, EnumFacing facing, int color) {
        super(box.copy(), null);
        this.facing = facing;
        this.color = color;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public boolean requiresSplit() {
        return false;
    }

    @Override
    public PlacePreview copy() {
        return new PlacePreviewFacing(this.box.copy(), this.facing, this.color);
    }

    @Override
    public List<LittleRenderBox> getPreviews(LittleGridContext context) {
        ArrayList<LittleRenderBox> cubes = new ArrayList<LittleRenderBox>();
        LittleRenderBox cube = new LittleRenderBox(this.box.getCube(context), this.box, LittleTiles.dyeableBlock, 0);
        cube.setColor(this.color);
        float thickness = 0.03125f;
        EnumFacing.Axis axis = this.facing.func_176740_k();
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + thickness);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - thickness);
        }
        cubes.add(cube);
        return cubes;
    }

    @Override
    public List<LittleTile> placeTile(Placement placement, Placement.PlacementBlock block, IParentTileList parent, LittleStructure structure, boolean requiresCollisionTest) {
        return Collections.EMPTY_LIST;
    }
}

