/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.location;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.exception.MissingAnimationException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileLocation {
    public final BlockPos pos;
    public final boolean isStructure;
    public final int index;
    public final LittleBox box;
    public final UUID worldUUID;

    public TileLocation(BlockPos pos, boolean isStructure, int index, LittleBox box, UUID world) {
        this.pos = pos;
        this.isStructure = isStructure;
        this.index = index;
        this.box = box;
        this.worldUUID = world;
    }

    public TileLocation(IParentTileList list, LittleTile tile) {
        if (list.isStructure()) {
            this.isStructure = true;
            this.index = ((StructureTileList)list).getIndex();
        } else {
            this.isStructure = false;
            this.index = -1;
        }
        this.pos = list.getPos();
        this.box = tile.getBox().copy();
        this.worldUUID = list.getWorld() instanceof CreativeWorld ? ((CreativeWorld)list.getWorld()).parent.func_110124_au() : null;
    }

    public TileLocation(NBTTagCompound nbt) {
        int[] posArray = nbt.func_74759_k("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.isStructure = nbt.func_74764_b("index");
        this.index = nbt.func_74762_e("index");
        this.box = LittleBox.createBox(nbt.func_74759_k("box"));
        this.worldUUID = nbt.func_74764_b("world") ? UUID.fromString(nbt.func_74779_i("world")) : null;
    }

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        if (this.isStructure) {
            nbt.func_74768_a("index", this.index);
        }
        nbt.func_74783_a("box", this.box.getArray());
        if (this.worldUUID != null) {
            nbt.func_74778_a("world", this.worldUUID.toString());
        }
        return nbt;
    }

    public Pair<IParentTileList, LittleTile> find(World world) throws LittleActionException {
        TileEntity te;
        if (this.worldUUID != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(world.field_72995_K, this.worldUUID);
            if (animation == null) {
                throw new MissingAnimationException(this.worldUUID);
            }
            world = animation.fakeWorld;
        }
        if ((te = world.func_175625_s(this.pos)) instanceof TileEntityLittleTiles) {
            IParentTileList list = ((TileEntityLittleTiles)te).noneStructureTiles();
            if (this.isStructure) {
                list = ((TileEntityLittleTiles)te).getStructure(this.index);
            }
            for (LittleTile tile : list) {
                if (!tile.getBox().equals(this.box)) continue;
                return new Pair((Object)list, (Object)tile);
            }
            throw new LittleActionException.TileNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

