/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.output;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.packet.LittleUpdateOutputPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.InternalSignal;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import java.text.ParseException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InternalSignalOutput
extends InternalSignal<LittleStructureType.InternalComponentOutput> {
    public final SignalMode defaultMode;
    public final boolean syncToClient;
    public SignalInputCondition condition;
    public SignalOutputHandler handler;

    public InternalSignalOutput(LittleStructure parent, LittleStructureType.InternalComponentOutput component) {
        super(parent, component);
        this.defaultMode = component.defaultMode;
        this.syncToClient = component.syncToClient;
    }

    @Override
    public void changed() {
        this.parent.performInternalOutputChange(this);
        this.parent.schedule();
        if (this.syncToClient) {
            PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleUpdateOutputPacket(this.parent.getStructureLocation(), ((LittleStructureType.InternalComponentOutput)this.component).index, this.getState()), (World)this.getStructureWorld(), (BlockPos)this.parent.getPos(), null);
        }
    }

    @Override
    public SignalComponentType getType() {
        return SignalComponentType.OUTPUT;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        BooleanUtils.intToBool((int)nbt.func_74762_e("state"), (boolean[])this.getState());
        try {
            this.condition = nbt.func_74764_b("con") ? SignalInputCondition.parseInput(nbt.func_74779_i("con")) : null;
        }
        catch (ParseException e) {
            this.condition = null;
        }
        SignalMode mode = this.defaultMode;
        if (nbt.func_74764_b("mode")) {
            mode = SignalMode.valueOf(nbt.func_74779_i("mode"));
        }
        int delay = nbt.func_74762_e("delay");
        if (this.condition != null) {
            delay = Math.max((int)Math.ceil(this.condition.calculateDelay()), nbt.func_74762_e("delay"));
        }
        this.handler = SignalOutputHandler.create(this, mode, delay, nbt, this.parent);
    }

    @Override
    public NBTTagCompound write(boolean preview, NBTTagCompound nbt) {
        nbt.func_74768_a("state", BooleanUtils.boolToInt((boolean[])this.getState()));
        if (this.condition != null) {
            nbt.func_74778_a("con", this.condition.write());
        }
        nbt.func_74778_a("mode", this.handler == null ? this.defaultMode.name() : this.handler.getMode().name());
        if (this.handler != null) {
            nbt.func_74768_a("delay", this.handler.delay);
            this.handler.write(preview, nbt);
        }
        return nbt;
    }

    public void toggle() {
        if (this.handler instanceof SignalMode.SignalOutputHandlerToggle) {
            ((SignalMode.SignalOutputHandlerToggle)this.handler).triggerToggle();
        }
    }

    public void update() {
        if (this.condition == null) {
            return;
        }
        int bandwidth = this.getBandwidth();
        if (bandwidth > 0) {
            boolean[] outputState = new boolean[bandwidth];
            boolean[] result = this.condition.test(this.getStructure(), false);
            if (result.length == 1) {
                Arrays.fill(outputState, result[0]);
            } else {
                for (int i = 0; i < result.length; ++i) {
                    if (i >= outputState.length) continue;
                    outputState[i] = result[i];
                }
            }
            this.handler.schedule(outputState);
        }
    }
}

