/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.directional;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalType;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.lang.reflect.Field;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class StructureDirectionalField {
    public final Field field;
    public final String key;
    public final String saveKey;
    public final StructureDirectional annotation;
    public final StructureDirectionalType type;
    private Object defaultValue;

    public StructureDirectionalField(Field field, StructureDirectional annotation) {
        this.field = field;
        this.key = field.getName();
        this.saveKey = annotation.saveKey().isEmpty() ? this.key : annotation.saveKey();
        this.annotation = annotation;
        this.type = StructureDirectionalType.getType(field);
    }

    public void set(LittleStructure structure, Object value) {
        try {
            this.field.set(structure, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(LittleStructure structure) {
        try {
            return this.field.get(structure);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object createAndSet(LittleStructure structure, NBTTagCompound nbt) {
        Object relative = this.create(nbt);
        this.set(structure, relative);
        return relative;
    }

    public void setDefault(Object value) {
        this.defaultValue = value;
    }

    public Object create(NBTTagCompound nbt) {
        Object value = this.type.read(nbt.func_74781_a(this.saveKey));
        if (value == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            return this.type.getDefault();
        }
        return value;
    }

    public void save(NBTTagCompound nbt, Object value) {
        nbt.func_74782_a(this.saveKey, this.type.write(value));
    }

    public Object move(Object value, LittleGridContext context, LittleVec offset) {
        return this.type.move(value, context, offset);
    }

    public Object flip(Object value, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
        return this.type.flip(value, context, axis, doubledCenter);
    }

    public Object rotate(Object value, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
        return this.type.rotate(value, context, rotation, doubledCenter);
    }

    public LittleGridContext getContext(Object value) {
        return this.type.getContext(value);
    }

    public void convertToSmallest(Object value) {
        this.type.convertToSmallest(value);
    }

    public void advancedScale(Object value, int from, int to) {
        this.type.advancedScale(value, from, to);
    }

    public PlacePreview getPlacePreview(Object value, LittlePreviews previews) {
        return this.type.getPlacePreview(value, previews, this);
    }

    public Object getDefault() {
        return this.defaultValue != null ? this.defaultValue : this.type.getDefault();
    }
}

