/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class LittleUpdateOutputPacket
extends CreativeCorePacket {
    public StructureLocation location;
    public int index;
    public boolean[] state;

    public LittleUpdateOutputPacket() {
    }

    public LittleUpdateOutputPacket(StructureLocation location, int index, boolean[] state) {
        this.location = location;
        this.index = index;
        this.state = state;
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation(this.location, buf);
        buf.writeInt(this.index);
        buf.writeInt(this.state.length);
        for (int i = 0; i < this.state.length; ++i) {
            buf.writeBoolean(this.state[i]);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation(buf);
        this.index = buf.readInt();
        this.state = new boolean[buf.readInt()];
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = buf.readBoolean();
        }
    }

    public void executeClient(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            InternalSignalOutput output = structure.getOutput(this.index);
            BooleanUtils.set((boolean[])output.getState(), (boolean[])this.state);
            structure.receiveInternalOutputChange(output);
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

