/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleAnimationDestroyPacket;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class LittleAnimationControllerPacket
extends CreativeCorePacket {
    public UUID uuid;
    public NBTTagCompound nbt;

    public LittleAnimationControllerPacket(EntityAnimation animation) {
        this(animation.func_110124_au(), animation.controller.writeToNBT(new NBTTagCompound()));
    }

    public LittleAnimationControllerPacket(UUID uuid, NBTTagCompound nbt) {
        this.uuid = uuid;
        this.nbt = nbt;
    }

    public LittleAnimationControllerPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAnimationControllerPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        LittleAnimationControllerPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleAnimationControllerPacket.readString((ByteBuf)buf));
        this.nbt = LittleAnimationControllerPacket.readNBT((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
        if (animation != null) {
            animation.controller = DoorController.parseController(animation, this.nbt);
            animation.updateTickState();
            return;
        }
        for (Entity entity : player.field_70170_p.func_175644_a(EntityAnimation.class, (Predicate)new Predicate<EntityAnimation>(){

            public boolean apply(EntityAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityAnimation)entity;
            animation.controller = DoorController.parseController(animation, this.nbt);
            animation.updateTickState();
            return;
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(false, this.uuid);
        if (animation != null) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleAnimationControllerPacket(this.uuid, animation.controller.writeToNBT(new NBTTagCompound())), (EntityPlayerMP)((EntityPlayerMP)player));
        } else {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleAnimationDestroyPacket(this.uuid, false), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

