/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public class ItemMultiTiles
extends Item
implements ICreativeRendered,
ILittlePlacer {
    public static PlacementMode currentMode = PlacementMode.getDefault();
    public static LittleGridContext currentContext;

    public ItemMultiTiles() {
        this.field_77787_bX = true;
        this.func_77637_a(LittleTiles.littleTab);
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure") && stack.func_77978_p().func_74775_l("structure").func_74764_b("name")) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("name");
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            String id = "none";
            if (stack.func_77978_p().func_74764_b("structure")) {
                id = stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
            }
            tooltip.add("structure: " + id);
            tooltip.add("contains " + stack.func_77978_p().func_74762_e("count") + " tiles");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (ExampleStructures example : ExampleStructures.values()) {
                if (example.stack == null) continue;
                list.add((Object)example.stack);
            }
        }
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        LittlePreview.savePreview(previews, stack);
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        return LittlePreview.getPreview(stack);
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution) {
        return LittlePreview.getPreview(stack, allowLowResolution);
    }

    public List<RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return LittlePreview.getCubesForStackRendering(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack != null) {
            ItemModelCache.cacheModel(stack, facing, cachedQuads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack == null) {
            return null;
        }
        return ItemModelCache.requestCache(stack, facing);
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!currentMode.canPlaceStructures() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure")) {
            return PlacementMode.getStructureDefault();
        }
        return currentMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, currentContext, currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                currentContext = context;
                currentMode = mode;
            }
        };
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return currentContext;
    }

    @Override
    public LittleVec getCachedSize(ItemStack stack) {
        if (stack.func_77978_p().func_74764_b("size")) {
            return LittlePreview.getSize(stack);
        }
        return null;
    }

    @Override
    public LittleVec getCachedOffset(ItemStack stack) {
        return LittlePreview.getOffset(stack);
    }

    public static void reloadExampleStructures() {
        for (ExampleStructures example : ExampleStructures.values()) {
            try {
                example.stack = new ItemStack(LittleTiles.multiTiles);
                example.stack.func_77982_d(JsonToNBT.func_180713_a((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream(example.getFileName()), (Charset)Charsets.UTF_8)));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not load '" + example.name() + " example structure!");
            }
        }
    }

    private static enum ExampleStructures {
        BASIC_LEVER,
        DOUBLE_DOOR,
        LIGHT_SWITCH,
        SIMPLE_LIGHT,
        STONE_PLATE,
        WOODEN_PLATE;

        public ItemStack stack;

        public String getFileName() {
            return "assets/littletiles/example/" + this.name().toLowerCase() + ".struct";
        }
    }
}

