/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LittleActionReplace
extends LittleActionInteract {
    public LittlePreview toReplace;
    public LittleAbsolutePreviews replacedTiles;
    public LittleBoxes boxes;

    public LittleActionReplace(World world, BlockPos blockPos, EntityPlayer player, LittlePreview toReplace) {
        super(world, blockPos, player);
        this.toReplace = toReplace;
    }

    public LittleActionReplace() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        this.toReplace.writeToNBT(nbt);
        LittleActionReplace.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toReplace = LittleTileRegistry.loadPreview(LittleActionReplace.readNBT((ByteBuf)buf));
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    protected boolean requiresBreakEvent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        this.replacedTiles = new LittleAbsolutePreviews(pos, te.getContext());
        this.boxes = new LittleBoxesSimple(pos, te.getContext());
        if (LittleTiles.CONFIG.isTransparencyRestricted(player)) {
            LittleActionReplace.isAllowedToPlacePreview(player, this.toReplace);
        }
        if (BlockTile.selectEntireBlock(player, secondMode)) {
            ArrayList<LittleTile> toRemove = new ArrayList<LittleTile>();
            LittlePreviews toBePlaced = new LittlePreviews(te.getContext());
            LittlePreviews previews = new LittlePreviews(te.getContext());
            parent = te.noneStructureTiles();
            for (LittleTile toDestroy : parent) {
                if (!tile.canBeCombined(toDestroy) || !toDestroy.canBeCombined(tile)) continue;
                this.replacedTiles.addTile(parent, toDestroy);
                this.boxes.addBox(parent, toDestroy);
                toBePlaced.addTile(parent, toDestroy);
                LittlePreview preview = this.toReplace.copy();
                preview.box = toDestroy.getBox();
                previews.addWithoutCheckingPreview(preview);
                toRemove.add(toDestroy);
            }
            if (toRemove.isEmpty()) {
                return false;
            }
            LittleInventory inventory = new LittleInventory(player);
            try {
                inventory.startSimulation();
                LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(toBePlaced));
                LittleActionReplace.give(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
            }
            finally {
                inventory.stopSimulation();
            }
            te.updateTilesSecretly(x -> x.noneStructureTiles().removeAll(toRemove));
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(world, previews, pos, PlacementMode.normal));
            LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(placement.place().placedPreviews));
            LittleActionReplace.checkAndGive(player, inventory, placement.overflow());
            LittleActionReplace.checkAndGive(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
        } else {
            if (parent.isStructure()) {
                return false;
            }
            LittleInventory inventory = new LittleInventory(player);
            this.replacedTiles.addTile(parent, tile);
            this.boxes.addBox(parent, tile);
            LittlePreviews toBePlaced = new LittlePreviews(te.getContext());
            this.toReplace.box = tile.getBox().copy();
            toBePlaced.addPreview(null, this.toReplace, te.getContext());
            try {
                inventory.startSimulation();
                LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(toBePlaced));
                LittleActionReplace.give(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
            }
            finally {
                inventory.stopSimulation();
            }
            te.updateTilesSecretly(x -> x.noneStructureTiles().remove(tile));
            LittlePreviews previews = new LittlePreviews(te.getContext());
            previews.addWithoutCheckingPreview(this.toReplace);
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(world, previews, pos, PlacementMode.normal));
            LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(placement.place().placedPreviews));
            LittleActionReplace.checkAndGive(player, inventory, placement.overflow());
            LittleActionReplace.checkAndGive(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) throws LittleActionException {
        return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.replacedTiles, PlacementMode.normal));
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox absoluteBox) {
        LittleBoxes boxes = this.boxes.copy();
        boxes.flip(axis, absoluteBox);
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(boxes.pos, boxes.context);
        for (LittleBox box : boxes.all()) {
            LittlePreview preview = this.toReplace.copy();
            preview.box = box;
            previews.addWithoutCheckingPreview(preview);
        }
        return new LittleActionCombined(new LittleActionDestroyBoxes(boxes), new LittleActionPlaceAbsolute(previews, PlacementMode.normal));
    }
}

