/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.item.ItemLittleWrench;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LittleActionDestroy
extends LittleActionInteract {
    public LittleAbsolutePreviews destroyedTiles;
    public StructurePreview structurePreview;

    public LittleActionDestroy(World world, BlockPos blockPos, EntityPlayer player) {
        super(world, blockPos, player);
    }

    public LittleActionDestroy() {
    }

    @Override
    public boolean canBeReverted() {
        return this.destroyedTiles != null || this.structurePreview != null;
    }

    @Override
    public LittleAction revert(EntityPlayer player) {
        if (this.structurePreview != null) {
            return this.structurePreview.getPlaceAction();
        }
        this.destroyedTiles.convertToSmallest();
        return new LittleActionPlaceAbsolute(this.destroyedTiles, PlacementMode.normal);
    }

    @Override
    protected boolean requiresBreakEvent() {
        return true;
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (parent.isStructure()) {
            try {
                LittleStructure structure = parent.getStructure();
                structure.load();
                this.structurePreview = new StructurePreview(structure);
                if (LittleActionDestroy.needIngredients(player) && !player.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)world, (ItemStack)structure.getStructureDrop(), (BlockPos)pos);
                }
                structure.onLittleTileDestroy();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                if (player.func_184614_ca().func_77973_b() instanceof ItemLittleWrench) {
                    ((StructureTileList)parent).remove();
                    te.updateTiles();
                }
                throw new LittleActionException.StructureNotLoadedException();
            }
        } else {
            LittleInventory inventory = new LittleInventory(player);
            this.destroyedTiles = new LittleAbsolutePreviews(pos, te.getContext());
            if (BlockTile.selectEntireBlock(player, secondMode)) {
                for (LittleTile toDestroy : parent) {
                    this.destroyedTiles.addTile(parent, toDestroy);
                }
                LittleActionDestroy.checkAndGive(player, inventory, LittleActionDestroy.getIngredients(this.destroyedTiles));
                te.updateTiles(x -> x.noneStructureTiles().clear());
            } else {
                this.destroyedTiles.addTile(parent, tile);
                LittleActionDestroy.checkAndGive(player, inventory, LittleActionDestroy.getIngredients(this.destroyedTiles));
                te.updateTiles(x -> x.get(parent).remove(tile));
            }
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        LittleBoxesSimple boxes;
        if (this.structurePreview != null) {
            boxes = new LittleBoxesSimple(this.structurePreview.previews.pos, this.structurePreview.previews.getContext());
            ((LittleBoxes)boxes).add(this.structurePreview.previews.get((int)0).box);
        } else if (this.destroyedTiles != null) {
            this.destroyedTiles.convertToSmallest();
            boxes = new LittleBoxesSimple(this.blockPos, this.destroyedTiles.getContext());
            for (LittlePreview preview : this.destroyedTiles) {
                ((LittleBoxes)boxes).add(preview.box);
            }
        } else {
            return null;
        }
        ((LittleBoxes)boxes).flip(axis, box);
        return new LittleActionDestroyBoxes(boxes);
    }

    public static class StructurePreview {
        public LittleAbsolutePreviews previews;
        public boolean requiresItemStack;
        public LittleStructure structure;

        public StructurePreview(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
            structure = structure.findTopStructure();
            structure.load();
            this.previews = structure.getAbsolutePreviews(structure.getPos());
            this.requiresItemStack = this.previews.getStructureType().canOnlyBePlacedByItemStack();
            this.structure = structure;
        }

        public LittleAction getPlaceAction() {
            if (this.requiresItemStack) {
                return new LittleActionPlaceAbsolute.LittleActionPlaceAbsolutePremade(this.previews, PlacementMode.all, false);
            }
            return new LittleActionPlaceAbsolute(this.previews, PlacementMode.all, false);
        }

        public int hashCode() {
            return this.previews.structureNBT.hashCode();
        }

        public boolean equals(Object paramObject) {
            if (paramObject instanceof StructurePreview) {
                return this.structure == ((StructurePreview)paramObject).structure;
            }
            if (paramObject instanceof LittleStructure) {
                return this.structure == paramObject;
            }
            return false;
        }
    }
}

