/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.world;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerCache;
import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerManager;
import com.creativemd.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import com.creativemd.littletiles.client.render.world.LightChangeEventListener;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LittleChunkDispatcher {
    public static int currentRenderState = Integer.MIN_VALUE;
    private static Method setLayerUseMethod = ReflectionHelper.findMethod(CompiledChunk.class, (String)"setLayerUsed", (String)"func_178486_a", (Class[])new Class[]{BlockRenderLayer.class});
    private static Field setTileEntities = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"setTileEntities", "field_181056_j"});
    private static Field littleTiles = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"littleTiles"});
    private static Field updateQueue = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"updateQueue"});
    private static Field dynamicLightUpdate = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"dynamicLightUpdate"});
    private static Minecraft mc = Minecraft.func_71410_x();
    public static final Field added = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"littleTilesAdded"});
    public static BufferBuilder.State emptyState = LittleChunkDispatcher.loadEmptyState();

    public static void onReloadRenderers(RenderGlobal renderGlobal) {
        if (LittleChunkDispatcher.mc.field_71438_f == renderGlobal) {
            ++currentRenderState;
            if (LittleChunkDispatcher.mc.field_71441_e != null) {
                LittleChunkDispatcher.mc.field_71441_e.func_72954_a((IWorldEventListener)new LightChangeEventListener());
            }
        }
    }

    public static void onOptifineMarksChunkRenderUpdateForDynamicLights(RenderChunk chunk) {
        try {
            dynamicLightUpdate.setBoolean(chunk, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void addTileEntity(List<TileEntityLittleTiles> tiles, TileEntity te) {
        if (te instanceof TileEntityLittleTiles) {
            tiles.add((TileEntityLittleTiles)te);
        }
    }

    public static void onDoneRendering(RenderChunk chunk, List<TileEntityLittleTiles> tiles) {
        try {
            littleTiles.set(chunk, tiles);
            updateQueue.setInt(chunk, updateQueue.getInt(chunk) + 1);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static List<TileEntityLittleTiles> getLittleTE(RenderChunk chunk) {
        try {
            return (List)littleTiles.get(chunk);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void uploadChunk(BlockRenderLayer layer, BufferBuilder buffer, RenderChunk chunk, CompiledChunk compiled, double p_188245_5_) {
        try {
            if (added.getBoolean(buffer)) {
                return;
            }
            if (buffer.func_178973_g() != null && (layer != BlockRenderLayer.TRANSLUCENT || compiled.func_178487_c() != emptyState && !(compiled.func_178487_c() instanceof LittleVertexBufferState))) {
                ChunkBlockLayerManager oldManager;
                VertexBuffer vertexBuffer;
                List<TileEntityLittleTiles> tiles = LittleChunkDispatcher.getLittleTE(chunk);
                if (tiles == null || tiles.isEmpty()) {
                    added.setBoolean(buffer, true);
                    return;
                }
                if (!tiles.isEmpty() && (vertexBuffer = chunk.func_178565_b(layer.ordinal())) != null && (oldManager = (ChunkBlockLayerManager)ChunkBlockLayerManager.blockLayerManager.get(vertexBuffer)) != null) {
                    oldManager.backToRAM();
                }
                boolean dynamicUpdate = false;
                if (layer == BlockRenderLayer.SOLID) {
                    dynamicUpdate = dynamicLightUpdate.getBoolean(chunk);
                }
                ChunkBlockLayerCache cache = new ChunkBlockLayerCache(layer.ordinal());
                if (!tiles.isEmpty()) {
                    for (TileEntityLittleTiles te : tiles) {
                        if (!te.hasLoaded()) continue;
                        if (layer == BlockRenderLayer.SOLID) {
                            if (dynamicUpdate) {
                                te.render.hasLightChanged = true;
                            }
                            te.updateQuadCache(chunk);
                        }
                        cache.add(te.render, te.render.getBufferCache().get(layer.ordinal()));
                    }
                }
                if (layer == BlockRenderLayer.SOLID) {
                    dynamicLightUpdate.setBoolean(chunk, false);
                }
                if (cache.expanded() > 0) {
                    if (compiled.func_178491_b(layer)) {
                        if (compiled != CompiledChunk.field_178502_a) {
                            setLayerUseMethod.invoke((Object)compiled, layer);
                        }
                        if (chunk.func_178571_g() != CompiledChunk.field_178502_a) {
                            setLayerUseMethod.invoke((Object)chunk.func_178571_g(), layer);
                        }
                    }
                    BufferBuilderUtils.growBufferSmall((BufferBuilder)buffer, (int)(cache.expanded() + buffer.func_178973_g().func_177338_f()));
                    cache.fillBuilder(buffer);
                    if (layer == BlockRenderLayer.TRANSLUCENT && buffer.func_178973_g() != null && mc.func_175606_aa() != null) {
                        Entity entity = mc.func_175606_aa();
                        float x = (float)entity.field_70165_t;
                        float y = (float)entity.field_70163_u + entity.func_70047_e();
                        float z = (float)entity.field_70161_v;
                        BlockPos pos = chunk.func_178568_j();
                        buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                        buffer.func_181674_a(x, y, z);
                        compiled.func_178494_a((BufferBuilder.State)new LittleVertexBufferState(buffer, buffer.func_181672_a()));
                    }
                    buffer.func_178966_f().position(0);
                    buffer.func_178966_f().limit(buffer.func_178973_g().func_177338_f() * buffer.func_178989_h());
                    added.setBoolean(buffer, true);
                    VertexBuffer vertexBuffer2 = chunk.func_178565_b(layer.ordinal());
                    if (layer != BlockRenderLayer.TRANSLUCENT && vertexBuffer2 != null) {
                        ChunkBlockLayerManager manager = (ChunkBlockLayerManager)ChunkBlockLayerManager.blockLayerManager.get(vertexBuffer2);
                        if (manager == null) {
                            manager = new ChunkBlockLayerManager(chunk, layer);
                            ChunkBlockLayerManager.blockLayerManager.set(vertexBuffer2, manager);
                        }
                        manager.set(cache);
                    }
                    ++LittleTilesProfilerOverlay.uploaded;
                }
            }
            int index = layer.ordinal();
            while (index < 3) {
                if (!compiled.func_178492_d(BlockRenderLayer.values()[++index])) continue;
                return;
            }
            updateQueue.setInt(chunk, updateQueue.getInt(chunk) - 1);
            if (updateQueue.getInt(chunk) == 0) {
                littleTiles.set(chunk, null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static BufferBuilder.State loadEmptyState() {
        BufferBuilder buffer = new BufferBuilder(0);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BufferBuilder.State state = buffer.func_181672_a();
        buffer.func_178977_d();
        return state;
    }

    public static void resortTransparency(RenderChunk chunk, float x, float y, float z, ChunkCompileTaskGenerator generator) {
        CompiledChunk compiledchunk = generator.func_178544_c();
        if (compiledchunk.func_178487_c() != null && !compiledchunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            BufferBuilder worldRendererIn = generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT);
            BlockPos pos = chunk.func_178568_j();
            worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldRendererIn.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            worldRendererIn.func_178993_a(compiledchunk.func_178487_c());
            worldRendererIn.func_181674_a(x, y, z);
            compiledchunk.func_178494_a((BufferBuilder.State)new LittleVertexBufferState(worldRendererIn, worldRendererIn.func_181672_a()));
            worldRendererIn.func_178977_d();
        } else {
            compiledchunk.func_178494_a(emptyState);
        }
    }

    private static float minAbs(float var0, float var1) {
        return Math.abs(var0) > Math.abs(var1) ? var1 : var0;
    }

    private static float closest(float to, float pos0, float pos1, float pos2, float pos3) {
        float f = pos0 - to;
        float f1 = pos1 - to;
        float f2 = pos2 - to;
        float f3 = pos3 - to;
        if ((f > 0.0f || f1 > 0.0f || f2 > 0.0f || f3 > 0.0f) && (f < 0.0f || f1 < 0.0f || f2 < 0.0f || f3 < 0.0f)) {
            return 0.0f;
        }
        return LittleChunkDispatcher.minAbs(f, LittleChunkDispatcher.minAbs(f1, LittleChunkDispatcher.minAbs(f2, f3)));
    }

    public static float getDistanceSq(FloatBuffer buffer, float x, float y, float z, int size, int index) {
        if (LittleTiles.CONFIG.rendering.enhancedResorting) {
            float f = buffer.get(index + 0);
            float f1 = buffer.get(index + 1);
            float f2 = buffer.get(index + 2);
            float f3 = buffer.get(index + size + 0);
            float f4 = buffer.get(index + size + 1);
            float f5 = buffer.get(index + size + 2);
            float f6 = buffer.get(index + size * 2 + 0);
            float f7 = buffer.get(index + size * 2 + 1);
            float f8 = buffer.get(index + size * 2 + 2);
            float f9 = buffer.get(index + size * 3 + 0);
            float f10 = buffer.get(index + size * 3 + 1);
            float f11 = buffer.get(index + size * 3 + 2);
            float closeX = LittleChunkDispatcher.closest(x, f, f3, f6, f9);
            float closeY = LittleChunkDispatcher.closest(y, f1, f4, f7, f10);
            float closeZ = LittleChunkDispatcher.closest(z, f2, f5, f8, f11);
            return closeX * closeX + closeY * closeY + closeZ * closeZ;
        }
        float f = buffer.get(index + size * 0 + 0);
        float f1 = buffer.get(index + size * 0 + 1);
        float f2 = buffer.get(index + size * 0 + 2);
        float f3 = buffer.get(index + size * 1 + 0);
        float f4 = buffer.get(index + size * 1 + 1);
        float f5 = buffer.get(index + size * 1 + 2);
        float f6 = buffer.get(index + size * 2 + 0);
        float f7 = buffer.get(index + size * 2 + 1);
        float f8 = buffer.get(index + size * 2 + 2);
        float f9 = buffer.get(index + size * 3 + 0);
        float f10 = buffer.get(index + size * 3 + 1);
        float f11 = buffer.get(index + size * 3 + 2);
        float f12 = (f + f3 + f6 + f9) * 0.25f - x;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y;
        float f14 = (f2 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public static class LittleVertexBufferState
    extends BufferBuilder.State {
        public LittleVertexBufferState(BufferBuilder buffer, BufferBuilder.State state) {
            BufferBuilder bufferBuilder = buffer;
            bufferBuilder.getClass();
            super(bufferBuilder, state.func_179013_a(), state.func_179016_d());
        }
    }
}

