/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.BufferLink;
import com.creativemd.littletiles.client.render.cache.IRenderDataCache;
import com.creativemd.littletiles.client.render.world.TileEntityRenderManager;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.BlockRenderLayer;

public class BlockRenderCache {
    public final TileEntityRenderManager manager;
    public final int length;
    public final int vertexCount;
    public ByteBuffer buffer;
    public BufferLink link;

    public BlockRenderCache(TileEntityRenderManager manager, int layer, IRenderDataCache cache, ByteBuffer buffer) {
        this.manager = manager;
        this.length = cache.length();
        this.vertexCount = cache.vertexCount();
        this.buffer = buffer;
        if (layer != BlockRenderLayer.TRANSLUCENT.ordinal()) {
            this.link = new BufferLink(buffer, this.length, this.vertexCount);
            manager.getBufferCache().setUploaded(this.link, layer);
        }
    }

    public void fill(BufferBuilder builder) {
        if (this.buffer == null) {
            return;
        }
        int index = BufferBuilderUtils.getBufferSizeByte((BufferBuilder)builder);
        BufferBuilderUtils.addBuffer((BufferBuilder)builder, (ByteBuffer)this.buffer, (int)this.length, (int)this.vertexCount);
        if (this.link != null) {
            this.link.merged(index);
        }
        this.buffer = null;
    }

    public void fill(ByteBuffer toUpload) {
        this.buffer.position(0);
        this.buffer.limit(this.length);
        if (this.link != null) {
            this.link.merged(toUpload.position());
        }
        toUpload.put(this.buffer);
        this.buffer = null;
    }
}

