/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.controls.gui.GuiArraySlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.item.ItemLittleRecipeAdvanced;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.selection.mode.SelectionMode;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class SubGuiRecipeAdvancedSelection
extends SubGuiConfigure {
    public SelectionMode.SelectionResult result;

    public SubGuiRecipeAdvancedSelection(ItemStack stack) {
        super(200, 200, stack);
    }

    @Override
    public void saveConfiguration() {
    }

    public void createControls() {
        final SelectionMode mode = ItemLittleRecipeAdvanced.getSelectionMode(this.stack);
        GuiComboBox box = new GuiComboBox("selection_mode", 0, 0, 100, SubGuiRecipeAdvancedSelection.translate(SelectionMode.names()));
        box.select(mode.name);
        this.controls.add(box);
        this.result = mode.generateResult(this.getPlayer().field_70170_p, this.stack);
        GuiCheckBox vanilla = new GuiCheckBox("includeVanilla", SubGuiRecipeAdvancedSelection.translate((String)"selection.include.vanilla"), 0, 23, false);
        if (this.result != null && this.result.blocks > 0) {
            vanilla.setCustomTooltip(new String[]{this.result.blocks + " block(s)"});
        } else {
            vanilla.enabled = false;
        }
        this.controls.add(vanilla);
        GuiCheckBox cb = new GuiCheckBox("includeCB", SubGuiRecipeAdvancedSelection.translate((String)"selection.include.cb"), 0, 43, true);
        if (this.result != null && this.result.cbBlocks > 0) {
            cb.setCustomTooltip(new String[]{this.result.cbBlocks + " block(s)", this.result.cbTiles + " tile(s)", this.result.minCBContext.size + " grid"});
        } else {
            cb.enabled = false;
        }
        this.controls.add(cb);
        GuiCheckBox lt = new GuiCheckBox("includeLT", SubGuiRecipeAdvancedSelection.translate((String)"selection.include.lt"), 0, 63, true);
        if (this.result != null && this.result.ltBlocks > 0) {
            lt.setCustomTooltip(new String[]{this.result.ltBlocks + " block(s)", this.result.ltTiles + " tile(s)", this.result.minLtContext.size + " grid"});
        } else {
            lt.enabled = false;
        }
        this.controls.add(lt);
        this.controls.add(new GuiCheckBox("remember_structure", SubGuiRecipeAdvancedSelection.translate((String)"selection.include.structure"), 0, 83, true));
        GuiLabel label = new GuiLabel("label_scale", SubGuiRecipeAdvancedSelection.translate((String)"selection.scale") + ":", 0, 102);
        this.controls.add(label);
        this.controls.add(new GuiArraySlider("scale", label.width + 5, 100, 100, 14, "", new String[]{""}));
        this.updateSlider();
        this.controls.add(new GuiButton("save", SubGuiRecipeAdvancedSelection.translate((String)"selection.save"), 114, 180, 80){

            public void onClicked(int x, int y, int button) {
                LittleGridContext selected;
                boolean rememberStructure = ((GuiCheckBox)SubGuiRecipeAdvancedSelection.this.get((String)"remember_structure")).value;
                boolean includeVanilla = ((GuiCheckBox)SubGuiRecipeAdvancedSelection.this.get((String)"includeVanilla")).value;
                boolean includeCB = ((GuiCheckBox)SubGuiRecipeAdvancedSelection.this.get((String)"includeCB")).value;
                boolean includeLT = ((GuiCheckBox)SubGuiRecipeAdvancedSelection.this.get((String)"includeLT")).value;
                try {
                    if (rememberStructure && mode.getPreviews(this.getPlayer().field_70170_p, this.getPlayer(), SubGuiRecipeAdvancedSelection.this.stack, includeVanilla, includeCB, includeLT, rememberStructure).isEmpty()) {
                        SubGuiRecipeAdvancedSelection.this.openButtonDialogDialog("Parent structure has to have at least one tile!\nDisable remember structure or adjust your selection.", new String[]{"ok"});
                        return;
                    }
                }
                catch (LittleActionException e) {
                    SubGuiRecipeAdvancedSelection.this.openButtonDialogDialog(e.getLocalizedMessage(), new String[]{1.translate((String)"gui.ok")});
                    return;
                }
                mode.saveSelection(SubGuiRecipeAdvancedSelection.this.stack);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("save_selection", true);
                nbt.func_74757_a("includeVanilla", includeVanilla);
                nbt.func_74757_a("includeCB", includeCB);
                nbt.func_74757_a("includeLT", includeLT);
                nbt.func_74757_a("remember_structure", rememberStructure);
                LittleGridContext minRequired = LittleGridContext.getMin();
                if (nbt.func_74767_n("includeCB") && SubGuiRecipeAdvancedSelection.this.result.minCBContext != null) {
                    minRequired = LittleGridContext.max(minRequired, SubGuiRecipeAdvancedSelection.this.result.minCBContext);
                }
                if (nbt.func_74767_n("includeLT") && SubGuiRecipeAdvancedSelection.this.result.minLtContext != null) {
                    minRequired = LittleGridContext.max(minRequired, SubGuiRecipeAdvancedSelection.this.result.minLtContext);
                }
                if (minRequired != (selected = LittleGridContext.context[(int)((double)(LittleGridContext.context.length - 1) - ((GuiArraySlider)SubGuiRecipeAdvancedSelection.this.get((String)"scale")).value)])) {
                    nbt.func_74768_a("grid", minRequired.size);
                    nbt.func_74768_a("aimedGrid", selected.size);
                }
                SubGuiRecipeAdvancedSelection.this.sendPacketToServer(nbt);
            }
        }.setEnabled(this.result != null));
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        this.stack.func_77982_d(nbt);
    }

    @CustomEventSubscribe
    public void onChanged(GuiControlChangedEvent event) {
        if (!event.source.is(new String[]{"scale"})) {
            this.updateSlider();
        }
    }

    public void updateSlider() {
        boolean includeLT;
        GuiArraySlider slider = (GuiArraySlider)this.get("scale");
        boolean includeVanilla = ((GuiCheckBox)this.get((String)"includeVanilla")).enabled && ((GuiCheckBox)this.get((String)"includeVanilla")).value;
        boolean includeCB = ((GuiCheckBox)this.get((String)"includeCB")).enabled && ((GuiCheckBox)this.get((String)"includeCB")).value;
        boolean bl = includeLT = ((GuiCheckBox)this.get((String)"includeLT")).enabled && ((GuiCheckBox)this.get((String)"includeLT")).value;
        if (this.result == null || !includeVanilla && !includeCB && !includeLT) {
            slider.setEnabled(false);
        } else {
            LittleGridContext minRequired = LittleGridContext.getMin();
            if (includeCB && this.result.minCBContext != null) {
                minRequired = LittleGridContext.max(minRequired, this.result.minCBContext);
            }
            if (includeLT && this.result.minLtContext != null) {
                minRequired = LittleGridContext.max(minRequired, this.result.minLtContext);
            }
            String value = slider.getValue();
            Object[] values = new String[LittleGridContext.context.length];
            for (LittleGridContext context : LittleGridContext.context) {
                values[values.length - 1 - context.index] = minRequired.size + ":" + context.size + " x" + context.pixelSize / minRequired.pixelSize + "";
            }
            slider.setValues((String[])values);
            if (ArrayUtils.contains((Object[])values, (Object)value)) {
                slider.select(value);
            } else {
                slider.select((String)values[values.length - 1 - minRequired.index]);
            }
            slider.setEnabled(true);
        }
    }
}

