/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.lib.BCLibProxy;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.relauncher.Side;

public class MessageContainer
implements IMessage {
    private int windowId;
    private int msgId;
    private PacketBufferBC payload;
    public static final IMessageHandler<MessageContainer, IMessage> HANDLER = (message, ctx) -> {
        try {
            int id = message.windowId;
            EntityPlayer player = BCLibProxy.getProxy().getPlayerForContext(ctx);
            if (player != null && player.field_71070_bA instanceof ContainerBC_Neptune && player.field_71070_bA.field_75152_c == id) {
                ContainerBC_Neptune container = (ContainerBC_Neptune)player.field_71070_bA;
                container.readMessage(message.msgId, message.payload, ctx.side, ctx);
                String extra = ((Object)((Object)container)).getClass() + ", id = " + container.getIdAllocator().getNameFor(message.msgId);
                MessageUtil.ensureEmpty((ByteBuf)message.payload, ctx.side == Side.CLIENT, extra);
            }
            IMessage iMessage = null;
            return iMessage;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        finally {
            message.payload.release();
        }
    };

    public MessageContainer() {
    }

    public MessageContainer(int windowId, int msgId, PacketBufferBC payload) {
        this.windowId = windowId;
        this.msgId = msgId;
        this.payload = payload;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.msgId = buf.readUnsignedShort();
        int payloadSize = buf.readUnsignedShort();
        ByteBuf read = buf.readBytes(payloadSize);
        this.payload = new PacketBufferBC(read);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeShort(this.msgId);
        int length = this.payload.readableBytes();
        buf.writeShort(length);
        buf.writeBytes((ByteBuf)this.payload, 0, length);
    }
}

